/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.versionchecker;

import java.awt.Component;
import java.awt.Frame;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.pentaho.reporting.designer.core.settings.WorkspaceSettings;
import org.pentaho.reporting.designer.core.versionchecker.UpdateInfo;
import org.pentaho.reporting.designer.core.versionchecker.VersionCheckerEnableDialog;
import org.pentaho.reporting.designer.core.versionchecker.VersionConfirmationDialog;
import org.pentaho.versionchecker.BasicVersionCheckerProvider;
import org.pentaho.versionchecker.IVersionCheckDataProvider;
import org.pentaho.versionchecker.IVersionCheckErrorHandler;
import org.pentaho.versionchecker.IVersionCheckResultHandler;
import org.pentaho.versionchecker.VersionChecker;

public class VersionCheckerUtility {
    private static final Log logger = LogFactory.getLog(VersionCheckerUtility.class);

    private VersionCheckerUtility() {
    }

    public static void handlerVersionCheck(Frame parent) {
        if (VersionCheckerUtility.isInitialCheck()) {
            VersionCheckerUtility.setCheckVersion(VersionCheckerUtility.getUserApprovalForVersionChecker(parent));
        }
        if (VersionCheckerUtility.getCheckVersion()) {
            VersionCheckerUtility.checkVersion(parent, false, true);
        }
    }

    private static void setCheckVersion(boolean checkVersion) {
        WorkspaceSettings.getInstance().setUseVersionChecker(checkVersion);
    }

    private static boolean isInitialCheck() {
        return WorkspaceSettings.getInstance().isInitialVersionCheck();
    }

    private static boolean getCheckVersion() {
        return WorkspaceSettings.getInstance().isUseVersionChecker();
    }

    private static boolean getUserApprovalForVersionChecker(Frame owner) {
        VersionCheckerEnableDialog dialog = new VersionCheckerEnableDialog(owner);
        return dialog.performEdit();
    }

    public static void checkVersion(Component parent, boolean forcePrompt, boolean exitOnLaunch) {
        boolean gaOnly;
        BasicVersionCheckerProvider dataProvider = new BasicVersionCheckerProvider(VersionCheckerUtility.class);
        boolean bl = gaOnly = !WorkspaceSettings.getInstance().isNotifyForAllBuilds();
        if (gaOnly) {
            dataProvider.setVersionRequestFlags(32);
        } else {
            dataProvider.setVersionRequestFlags(1);
        }
        VersionChecker vc = new VersionChecker();
        vc.setDataProvider((IVersionCheckDataProvider)dataProvider);
        vc.addResultHandler((IVersionCheckResultHandler)new InternalResultHandler(parent, forcePrompt, exitOnLaunch));
        vc.addErrorHandler((IVersionCheckErrorHandler)new NoPromptErrorHandler());
        Thread vcThread = new Thread(new VersionCheckerRunnable(vc));
        vcThread.setDaemon(true);
        vcThread.start();
    }

    private static class NoPromptErrorHandler
    implements IVersionCheckErrorHandler {
        private NoPromptErrorHandler() {
        }

        public void handleException(Exception e) {
            logger.error((Object)"The version checker encountered an error", (Throwable)e);
        }
    }

    private static class InternalResultHandler
    implements IVersionCheckResultHandler {
        private Component parent;
        private final boolean forcePrompt;
        private final boolean exitOnLaunch;

        protected InternalResultHandler(Component parent, boolean forcePrompt, boolean exitOnLaunch) {
            this.parent = parent;
            this.forcePrompt = forcePrompt;
            this.exitOnLaunch = exitOnLaunch;
        }

        public void processResults(String result) {
            try {
                SAXReader reader = new SAXReader();
                Document templateDoc = reader.read((InputStream)new ByteArrayInputStream(result.getBytes()));
                ArrayList<UpdateInfo> updates = new ArrayList<UpdateInfo>();
                List updateElements = templateDoc.getRootElement().selectNodes("/vercheck/product/update");
                for (int i = 0; i < updateElements.size(); ++i) {
                    Element updateElement = (Element)updateElements.get(i);
                    String version = updateElement.attributeValue("version");
                    String type = updateElement.attributeValue("type");
                    String downloadUrl = updateElement.selectSingleNode("downloadurl").getText();
                    UpdateInfo info = new UpdateInfo(version, type, downloadUrl);
                    updates.add(info);
                }
                if (updates.isEmpty()) {
                    if (this.forcePrompt) {
                        JOptionPane.showMessageDialog(this.parent, "No update is available at this time.", "Version Update Info", 1);
                    }
                    return;
                }
                if (this.forcePrompt || !((UpdateInfo)updates.get(updates.size() - 1)).getVersion().equals(WorkspaceSettings.getInstance().getLastPromptedVersionUpdate())) {
                    UpdateInfo[] updateInfos = updates.toArray(new UpdateInfo[updates.size()]);
                    VersionConfirmationDialog.performUpdateAvailable(this.parent, updateInfos, this.exitOnLaunch);
                }
            }
            catch (Exception e) {
                logger.error((Object)"The version checker encountered an error", (Throwable)e);
                JOptionPane.showMessageDialog(this.parent, "No update is available at this time.", "Version Update Info", 1);
            }
        }
    }

    private static class VersionCheckerRunnable
    implements Runnable {
        private VersionChecker vc;

        public VersionCheckerRunnable(VersionChecker vc) {
            if (vc == null) {
                throw new NullPointerException();
            }
            this.vc = vc;
        }

        @Override
        public void run() {
            this.vc.performCheck(false);
        }
    }
}

