/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.xul;

import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenuBar;
import org.pentaho.reporting.designer.core.DesignerContextComponent;
import org.pentaho.reporting.designer.core.ReportDesignerContext;
import org.pentaho.reporting.designer.core.ReportDesignerUiPlugin;
import org.pentaho.reporting.designer.core.ReportDesignerUiPluginRegistry;
import org.pentaho.reporting.designer.core.xul.ActionSwingMenuitem;
import org.pentaho.reporting.designer.core.xul.ActionSwingXulLoader;
import org.pentaho.ui.xul.XulComponent;
import org.pentaho.ui.xul.XulDomContainer;
import org.pentaho.ui.xul.XulException;
import org.pentaho.ui.xul.XulLoader;
import org.pentaho.ui.xul.containers.XulMenu;
import org.pentaho.ui.xul.containers.XulMenupopup;
import org.pentaho.ui.xul.containers.XulWindow;
import org.pentaho.ui.xul.dom.Document;
import org.pentaho.ui.xul.dom.Element;
import org.pentaho.ui.xul.impl.XulEventHandler;

public class XulDesignerFrame {
    private static final String DIALOG_DEFINITION_FILE = "org/pentaho/reporting/designer/core/xul/designer-frame.xul";
    private XulWindow window;
    private ReportDesignerContext reportDesignerContext;

    public XulDesignerFrame() throws XulException {
        int j;
        ReportDesignerUiPlugin plugin;
        int i;
        ActionSwingXulLoader loader = new ActionSwingXulLoader();
        ReportDesignerUiPlugin[] plugins = ReportDesignerUiPluginRegistry.getInstance().getPlugins();
        for (int i2 = 0; i2 < plugins.length; ++i2) {
            ReportDesignerUiPlugin plugin2 = plugins[i2];
            Map<String, String> map = plugin2.getXulAdditionalHandlers();
            for (Map.Entry<String, String> entry : map.entrySet()) {
                loader.register(entry.getKey(), entry.getValue());
            }
        }
        XulDomContainer container = loader.loadXul(DIALOG_DEFINITION_FILE);
        Document documentRoot = container.getDocumentRoot();
        for (i = 0; i < plugins.length; ++i) {
            plugin = plugins[i];
            String[] strings = plugin.getOverlaySources();
            for (j = 0; j < strings.length; ++j) {
                String source = strings[j];
                documentRoot.addOverlay(source);
            }
        }
        for (i = 0; i < plugins.length; ++i) {
            plugin = plugins[i];
            XulEventHandler[] xulEventHandlers = plugin.createEventHandlers();
            for (j = 0; j < xulEventHandlers.length; ++j) {
                XulEventHandler eventHandler = xulEventHandlers[j];
                container.addEventHandler(eventHandler);
            }
        }
        container.initialize();
        XulComponent root = documentRoot.getRootElement();
        if (!(root instanceof XulWindow)) {
            throw new XulException("Error getting Xul Database Dialog root, element of type: " + root);
        }
        this.window = (XulWindow)root;
    }

    public XulWindow getWindow() {
        return this.window;
    }

    public JMenuBar getMenuBar() {
        return this.getComponent("main-menubar", JMenuBar.class);
    }

    public <T extends XulComponent> T getXulComponent(String id, Class<T> type) {
        XulComponent mainMenuBar = this.window.getElementById(id);
        if (mainMenuBar == null) {
            return null;
        }
        if (type.isInstance(mainMenuBar)) {
            return (T)mainMenuBar;
        }
        return null;
    }

    public <T extends JComponent> T getComponent(String id, Class<T> type) {
        XulComponent mainMenuBar = this.window.getElementById(id);
        if (mainMenuBar == null) {
            return null;
        }
        Object o = mainMenuBar.getManagedObject();
        if (type.isInstance(o)) {
            return (T)((JComponent)o);
        }
        return null;
    }

    public void setReportDesignerContext(ReportDesignerContext reportDesignerContext) {
        this.reportDesignerContext = reportDesignerContext;
        this.installContext((XulComponent)this.window);
    }

    public ReportDesignerContext getReportDesignerContext() {
        return this.reportDesignerContext;
    }

    private void installContext(XulComponent component) {
        List xulComponents = component.getChildNodes();
        for (int i = 0; i < xulComponents.size(); ++i) {
            XulComponent child = (XulComponent)xulComponents.get(i);
            if (child instanceof DesignerContextComponent) {
                DesignerContextComponent asm = (DesignerContextComponent)child;
                asm.setReportDesignerContext(this.reportDesignerContext);
            }
            this.installContext(child);
        }
    }

    public ActionSwingMenuitem createMenu(Action action) {
        ActionSwingMenuitem item = new ActionSwingMenuitem(null, null, null, "menu-item");
        item.setAction(action);
        return item;
    }

    public XulMenupopup createPopupMenu(String label, XulComponent parent) throws XulException {
        XulLoader xulLoader = this.window.getXulDomContainer().getXulLoader();
        XulMenu menu = (XulMenu)xulLoader.createElement("MENU");
        menu.setLabel(label);
        parent.addChild((Element)menu);
        XulMenupopup childPopup = (XulMenupopup)xulLoader.createElement("MENUPOPUP");
        menu.addChild((Element)childPopup);
        return childPopup;
    }
}

