/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.repl.bootstrap.events.filesystem;

import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.repl.bootstrap.events.BootstrapEvent;
import org.apache.hadoop.hive.ql.exec.repl.bootstrap.events.filesystem.DatabaseEventsIterator;
import org.apache.hadoop.hive.ql.exec.repl.bootstrap.load.ReplicationState;
import org.apache.hadoop.hive.ql.parse.EximUtil;
import org.apache.hadoop.hive.ql.parse.repl.ReplLogger;
import org.apache.hadoop.hive.ql.parse.repl.load.log.BootstrapLoadLogger;

public class BootstrapEventsIterator
implements Iterator<BootstrapEvent> {
    private DatabaseEventsIterator currentDatabaseIterator = null;
    private Iterator<DatabaseEventsIterator> dbEventsIterator;
    private final String dumpDirectory;
    private final String dbNameToLoadIn;
    private final HiveConf hiveConf;
    private ReplLogger replLogger;

    public BootstrapEventsIterator(String dumpDirectory, String dbNameToLoadIn, HiveConf hiveConf) throws IOException {
        Path path = new Path(dumpDirectory);
        FileSystem fileSystem = path.getFileSystem((Configuration)hiveConf);
        FileStatus[] fileStatuses = fileSystem.listStatus(new Path(dumpDirectory), EximUtil.getDirectoryFilter(fileSystem));
        List dbsToCreate = Arrays.stream(fileStatuses).filter(f -> {
            Path metadataPath = new Path(f.getPath() + "/" + "_metadata");
            try {
                return fileSystem.exists(metadataPath);
            }
            catch (IOException e) {
                throw new RuntimeException("could not determine if exists : " + metadataPath.toString(), e);
            }
        }).collect(Collectors.toList());
        this.dbEventsIterator = dbsToCreate.stream().map(f -> {
            try {
                return new DatabaseEventsIterator(f.getPath(), hiveConf);
            }
            catch (IOException e) {
                throw new RuntimeException("Error while creating event iterator for db at path" + f.getPath().toString(), e);
            }
        }).collect(Collectors.toList()).iterator();
        this.dumpDirectory = dumpDirectory;
        this.dbNameToLoadIn = dbNameToLoadIn;
        this.hiveConf = hiveConf;
    }

    @Override
    public boolean hasNext() {
        while (true) {
            if (this.currentDatabaseIterator == null) {
                if (this.dbEventsIterator.hasNext()) {
                    this.currentDatabaseIterator = this.dbEventsIterator.next();
                    this.initReplLogger();
                    continue;
                }
                return false;
            }
            if (this.currentDatabaseIterator.hasNext()) {
                return true;
            }
            this.currentDatabaseIterator = null;
        }
    }

    @Override
    public BootstrapEvent next() {
        return this.currentDatabaseIterator.next();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("This operation is not supported");
    }

    @Override
    public void forEachRemaining(Consumer<? super BootstrapEvent> action) {
        throw new UnsupportedOperationException("This operation is not supported");
    }

    public boolean currentDbHasNext() {
        return this.currentDatabaseIterator != null && this.currentDatabaseIterator.hasNext();
    }

    public void setReplicationState(ReplicationState replicationState) {
        this.currentDatabaseIterator.replicationState = replicationState;
    }

    public ReplLogger replLogger() {
        return this.replLogger;
    }

    private void initReplLogger() {
        try {
            Path dbDumpPath = this.currentDatabaseIterator.dbLevelPath();
            FileSystem fs = dbDumpPath.getFileSystem((Configuration)this.hiveConf);
            long numTables = this.getSubDirs(fs, dbDumpPath).length;
            long numFunctions = 0L;
            Path funcPath = new Path(dbDumpPath, "_functions");
            if (fs.exists(funcPath)) {
                numFunctions = this.getSubDirs(fs, funcPath).length;
            }
            String dbName = StringUtils.isBlank((String)this.dbNameToLoadIn) ? dbDumpPath.getName() : this.dbNameToLoadIn;
            this.replLogger = new BootstrapLoadLogger(dbName, this.dumpDirectory, numTables, numFunctions);
            this.replLogger.startLog();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    FileStatus[] getSubDirs(FileSystem fs, Path dirPath) throws IOException {
        return fs.listStatus(dirPath, new PathFilter(){

            public boolean accept(Path p) {
                String name = p.getName();
                return !name.startsWith("_") && !name.startsWith(".");
            }
        });
    }
}

