/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import com.google.common.collect.ImmutableList;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.hive.metastore.api.EnvironmentContext;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Order;
import org.apache.hadoop.hive.metastore.api.SQLCheckConstraint;
import org.apache.hadoop.hive.metastore.api.SQLDefaultConstraint;
import org.apache.hadoop.hive.metastore.api.SQLForeignKey;
import org.apache.hadoop.hive.metastore.api.SQLNotNullConstraint;
import org.apache.hadoop.hive.metastore.api.SQLPrimaryKey;
import org.apache.hadoop.hive.metastore.api.SQLUniqueConstraint;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.ParseUtils;
import org.apache.hadoop.hive.ql.parse.ReplicationSpec;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.DDLDesc;
import org.apache.hadoop.hive.ql.plan.Explain;
import org.apache.hadoop.hive.ql.plan.PrincipalDesc;
import org.apache.hadoop.hive.ql.plan.ValidationUtility;

@Explain(displayName="Alter Table", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
public class AlterTableDesc
extends DDLDesc
implements Serializable,
DDLDesc.DDLDescWithWriteId {
    private static final long serialVersionUID = 1L;
    public static final Set<AlterTableTypes> alterTableTypesWithPartialSpec = new HashSet<AlterTableTypes>();
    AlterTableTypes op;
    String oldName;
    String newName;
    ArrayList<FieldSchema> newCols;
    String serdeName;
    HashMap<String, String> props;
    String inputFormat;
    String outputFormat;
    String storageHandler;
    int numberBuckets;
    ArrayList<String> bucketColumns;
    ArrayList<Order> sortColumns;
    String oldColName;
    String newColName;
    String newColType;
    String newColComment;
    boolean first;
    String afterCol;
    boolean expectView;
    HashMap<String, String> partSpec;
    private String newLocation;
    boolean protectModeEnable;
    ProtectModeType protectModeType;
    Map<List<String>, String> skewedLocations;
    boolean isTurnOffSkewed = false;
    boolean isStoredAsSubDirectories = false;
    List<String> skewedColNames;
    List<List<String>> skewedColValues;
    Table tableForSkewedColValidation;
    boolean isDropIfExists = false;
    boolean isTurnOffSorting = false;
    boolean isCascade = false;
    EnvironmentContext environmentContext;
    String dropConstraintName;
    List<SQLPrimaryKey> primaryKeyCols;
    List<SQLForeignKey> foreignKeyCols;
    List<SQLUniqueConstraint> uniqueConstraintCols;
    List<SQLNotNullConstraint> notNullConstraintCols;
    List<SQLDefaultConstraint> defaultConstraintsCols;
    List<SQLCheckConstraint> checkConstraintsCols;
    ReplicationSpec replicationSpec;
    private Long writeId = null;
    PrincipalDesc ownerPrincipal;

    public AlterTableDesc() {
    }

    public AlterTableDesc(String tblName, HashMap<String, String> partSpec, String oldColName, String newColName, String newType, String newComment, boolean first, String afterCol, boolean isCascade) throws SemanticException {
        this.setOldName(tblName);
        this.partSpec = partSpec;
        this.oldColName = oldColName;
        this.newColName = newColName;
        this.newColType = newType;
        this.newColComment = newComment;
        this.first = first;
        this.afterCol = afterCol;
        this.op = AlterTableTypes.RENAMECOLUMN;
        this.isCascade = isCascade;
    }

    public AlterTableDesc(String tblName, HashMap<String, String> partSpec, String oldColName, String newColName, String newType, String newComment, boolean first, String afterCol, boolean isCascade, List<SQLPrimaryKey> primaryKeyCols, List<SQLForeignKey> foreignKeyCols, List<SQLUniqueConstraint> uniqueConstraintCols, List<SQLNotNullConstraint> notNullConstraintCols, List<SQLDefaultConstraint> defaultConstraints, List<SQLCheckConstraint> checkConstraints) throws SemanticException {
        this.setOldName(tblName);
        this.partSpec = partSpec;
        this.oldColName = oldColName;
        this.newColName = newColName;
        this.newColType = newType;
        this.newColComment = newComment;
        this.first = first;
        this.afterCol = afterCol;
        this.op = AlterTableTypes.RENAMECOLUMN;
        this.isCascade = isCascade;
        this.primaryKeyCols = primaryKeyCols;
        this.foreignKeyCols = foreignKeyCols;
        this.uniqueConstraintCols = uniqueConstraintCols;
        this.notNullConstraintCols = notNullConstraintCols;
        this.defaultConstraintsCols = defaultConstraints;
        this.checkConstraintsCols = checkConstraints;
    }

    public AlterTableDesc(String oldName, String newName, boolean expectView, ReplicationSpec replicationSpec) throws SemanticException {
        this.op = AlterTableTypes.RENAME;
        this.setOldName(oldName);
        this.newName = newName;
        this.expectView = expectView;
        this.replicationSpec = replicationSpec;
    }

    public AlterTableDesc(String name, HashMap<String, String> partSpec, List<FieldSchema> newCols, AlterTableTypes alterType, boolean isCascade) throws SemanticException {
        this.op = alterType;
        this.setOldName(name);
        this.newCols = new ArrayList<FieldSchema>(newCols);
        this.partSpec = partSpec;
        this.isCascade = isCascade;
    }

    public AlterTableDesc(AlterTableTypes alterType, ReplicationSpec replicationSpec) {
        this.op = alterType;
        this.replicationSpec = replicationSpec;
    }

    public AlterTableDesc(AlterTableTypes alterType) {
        this(alterType, null, false);
    }

    public AlterTableDesc(AlterTableTypes alterType, HashMap<String, String> partSpec, boolean expectView) {
        this.op = alterType;
        this.partSpec = partSpec;
        this.expectView = expectView;
    }

    public AlterTableDesc(String name, String inputFormat, String outputFormat, String serdeName, String storageHandler, HashMap<String, String> partSpec) throws SemanticException {
        this.op = AlterTableTypes.ADDFILEFORMAT;
        this.setOldName(name);
        this.inputFormat = inputFormat;
        this.outputFormat = outputFormat;
        this.serdeName = serdeName;
        this.storageHandler = storageHandler;
        this.partSpec = partSpec;
    }

    public AlterTableDesc(String tableName, int numBuckets, List<String> bucketCols, List<Order> sortCols, HashMap<String, String> partSpec) throws SemanticException {
        this.setOldName(tableName);
        this.op = AlterTableTypes.ADDCLUSTERSORTCOLUMN;
        this.numberBuckets = numBuckets;
        this.bucketColumns = new ArrayList<String>(bucketCols);
        this.sortColumns = new ArrayList<Order>(sortCols);
        this.partSpec = partSpec;
    }

    public AlterTableDesc(String tableName, boolean sortingOff, HashMap<String, String> partSpec) throws SemanticException {
        this.setOldName(tableName);
        this.op = AlterTableTypes.ADDCLUSTERSORTCOLUMN;
        this.isTurnOffSorting = sortingOff;
        this.partSpec = partSpec;
    }

    public AlterTableDesc(String tableName, String newLocation, HashMap<String, String> partSpec) throws SemanticException {
        this.op = AlterTableTypes.ALTERLOCATION;
        this.setOldName(tableName);
        this.newLocation = newLocation;
        this.partSpec = partSpec;
    }

    public AlterTableDesc(String tableName, Map<List<String>, String> locations, HashMap<String, String> partSpec) throws SemanticException {
        this.op = AlterTableTypes.ALTERSKEWEDLOCATION;
        this.setOldName(tableName);
        this.skewedLocations = locations;
        this.partSpec = partSpec;
    }

    public AlterTableDesc(String tableName, boolean turnOffSkewed, List<String> skewedColNames, List<List<String>> skewedColValues) throws SemanticException {
        this.setOldName(tableName);
        this.op = AlterTableTypes.ADDSKEWEDBY;
        this.isTurnOffSkewed = turnOffSkewed;
        this.skewedColNames = new ArrayList<String>(skewedColNames);
        this.skewedColValues = new ArrayList<List<String>>(skewedColValues);
    }

    public AlterTableDesc(String tableName, HashMap<String, String> partSpec, int numBuckets) throws SemanticException {
        this.op = AlterTableTypes.ALTERBUCKETNUM;
        this.setOldName(tableName);
        this.partSpec = partSpec;
        this.numberBuckets = numBuckets;
    }

    public AlterTableDesc(String tableName, String dropConstraintName, ReplicationSpec replicationSpec) throws SemanticException {
        this.setOldName(tableName);
        this.dropConstraintName = dropConstraintName;
        this.replicationSpec = replicationSpec;
        this.op = AlterTableTypes.DROPCONSTRAINT;
    }

    public AlterTableDesc(String tableName, List<SQLPrimaryKey> primaryKeyCols, List<SQLForeignKey> foreignKeyCols, List<SQLUniqueConstraint> uniqueConstraintCols, ReplicationSpec replicationSpec) throws SemanticException {
        this.setOldName(tableName);
        this.primaryKeyCols = primaryKeyCols;
        this.foreignKeyCols = foreignKeyCols;
        this.uniqueConstraintCols = uniqueConstraintCols;
        this.replicationSpec = replicationSpec;
        this.op = AlterTableTypes.ADDCONSTRAINT;
    }

    public AlterTableDesc(String tableName, List<SQLPrimaryKey> primaryKeyCols, List<SQLForeignKey> foreignKeyCols, List<SQLUniqueConstraint> uniqueConstraintCols, List<SQLNotNullConstraint> notNullConstraintCols, List<SQLDefaultConstraint> defaultConstraints, List<SQLCheckConstraint> checkConstraints, ReplicationSpec replicationSpec) throws SemanticException {
        this.setOldName(tableName);
        this.primaryKeyCols = primaryKeyCols;
        this.foreignKeyCols = foreignKeyCols;
        this.uniqueConstraintCols = uniqueConstraintCols;
        this.notNullConstraintCols = notNullConstraintCols;
        this.defaultConstraintsCols = defaultConstraints;
        this.checkConstraintsCols = checkConstraints;
        this.replicationSpec = replicationSpec;
        this.op = AlterTableTypes.ADDCONSTRAINT;
    }

    public AlterTableDesc(String tableName, PrincipalDesc ownerPrincipal) {
        this.op = AlterTableTypes.OWNER;
        this.oldName = tableName;
        this.ownerPrincipal = ownerPrincipal;
    }

    public void setOwnerPrincipal(PrincipalDesc ownerPrincipal) {
        this.ownerPrincipal = ownerPrincipal;
    }

    @Explain(displayName="owner")
    public PrincipalDesc getOwnerPrincipal() {
        return this.ownerPrincipal;
    }

    @Explain(displayName="new columns", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public List<String> getNewColsString() {
        return Utilities.getFieldSchemaString(this.getNewCols());
    }

    @Explain(displayName="type", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public String getAlterTableTypeString() {
        return this.op.getName();
    }

    @Explain(displayName="old name", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public String getOldName() {
        return this.oldName;
    }

    public void setOldName(String oldName) throws SemanticException {
        this.oldName = String.join((CharSequence)".", Utilities.getDbTableName(oldName));
    }

    @Explain(displayName="new name", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public String getNewName() {
        return this.newName;
    }

    public void setNewName(String newName) {
        this.newName = newName;
    }

    public AlterTableTypes getOp() {
        return this.op;
    }

    public void setOp(AlterTableTypes op) {
        this.op = op;
    }

    public ArrayList<FieldSchema> getNewCols() {
        return this.newCols;
    }

    public void setNewCols(ArrayList<FieldSchema> newCols) {
        this.newCols = newCols;
    }

    @Explain(displayName="deserializer library")
    public String getSerdeName() {
        return this.serdeName;
    }

    public void setSerdeName(String serdeName) {
        this.serdeName = serdeName;
    }

    @Explain(displayName="properties")
    public HashMap<String, String> getProps() {
        return this.props;
    }

    public void setProps(HashMap<String, String> props) {
        this.props = props;
    }

    @Explain(displayName="input format", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public String getInputFormat() {
        return this.inputFormat;
    }

    public void setInputFormat(String inputFormat) {
        this.inputFormat = inputFormat;
    }

    @Explain(displayName="output format", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public String getOutputFormat() {
        return this.outputFormat;
    }

    public void setOutputFormat(String outputFormat) {
        this.outputFormat = outputFormat;
    }

    @Explain(displayName="storage handler", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public String getStorageHandler() {
        return this.storageHandler;
    }

    public void setPrimaryKeyCols(List<SQLPrimaryKey> primaryKeyCols) {
        this.primaryKeyCols = primaryKeyCols;
    }

    public List<SQLPrimaryKey> getPrimaryKeyCols() {
        return this.primaryKeyCols;
    }

    public void setForeignKeyCols(List<SQLForeignKey> foreignKeyCols) {
        this.foreignKeyCols = foreignKeyCols;
    }

    public List<SQLForeignKey> getForeignKeyCols() {
        return this.foreignKeyCols;
    }

    public List<SQLUniqueConstraint> getUniqueConstraintCols() {
        return this.uniqueConstraintCols;
    }

    public List<SQLNotNullConstraint> getNotNullConstraintCols() {
        return this.notNullConstraintCols;
    }

    public List<SQLDefaultConstraint> getDefaultConstraintCols() {
        return this.defaultConstraintsCols;
    }

    public List<SQLCheckConstraint> getCheckConstraintCols() {
        return this.checkConstraintsCols;
    }

    @Explain(displayName="drop constraint name", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public String getConstraintName() {
        return this.dropConstraintName;
    }

    public void setDropConstraintName(String constraintName) {
        this.dropConstraintName = constraintName;
    }

    public void setStorageHandler(String storageHandler) {
        this.storageHandler = storageHandler;
    }

    public int getNumberBuckets() {
        return this.numberBuckets;
    }

    public void setNumberBuckets(int numberBuckets) {
        this.numberBuckets = numberBuckets;
    }

    public ArrayList<String> getBucketColumns() {
        return this.bucketColumns;
    }

    public void setBucketColumns(ArrayList<String> bucketColumns) {
        this.bucketColumns = bucketColumns;
    }

    public ArrayList<Order> getSortColumns() {
        return this.sortColumns;
    }

    public void setSortColumns(ArrayList<Order> sortColumns) {
        this.sortColumns = sortColumns;
    }

    public String getOldColName() {
        return this.oldColName;
    }

    public void setOldColName(String oldColName) {
        this.oldColName = oldColName;
    }

    public String getNewColName() {
        return this.newColName;
    }

    public void setNewColName(String newColName) {
        this.newColName = newColName;
    }

    public String getNewColType() {
        return this.newColType;
    }

    public void setNewColType(String newType) {
        this.newColType = newType;
    }

    public String getNewColComment() {
        return this.newColComment;
    }

    public void setNewColComment(String newComment) {
        this.newColComment = newComment;
    }

    public boolean getFirst() {
        return this.first;
    }

    public void setFirst(boolean first) {
        this.first = first;
    }

    public String getAfterCol() {
        return this.afterCol;
    }

    public void setAfterCol(String afterCol) {
        this.afterCol = afterCol;
    }

    public boolean getExpectView() {
        return this.expectView;
    }

    public void setExpectView(boolean expectView) {
        this.expectView = expectView;
    }

    public HashMap<String, String> getPartSpec() {
        return this.partSpec;
    }

    public void setPartSpec(HashMap<String, String> partSpec) {
        this.partSpec = partSpec;
    }

    public String getNewLocation() {
        return this.newLocation;
    }

    public void setNewLocation(String newLocation) {
        this.newLocation = newLocation;
    }

    public boolean isProtectModeEnable() {
        return this.protectModeEnable;
    }

    public void setProtectModeEnable(boolean protectModeEnable) {
        this.protectModeEnable = protectModeEnable;
    }

    public ProtectModeType getProtectModeType() {
        return this.protectModeType;
    }

    public void setProtectModeType(ProtectModeType protectModeType) {
        this.protectModeType = protectModeType;
    }

    public Map<List<String>, String> getSkewedLocations() {
        return this.skewedLocations;
    }

    public void setSkewedLocations(Map<List<String>, String> skewedLocations) {
        this.skewedLocations = skewedLocations;
    }

    public boolean isTurnOffSorting() {
        return this.isTurnOffSorting;
    }

    public boolean isTurnOffSkewed() {
        return this.isTurnOffSkewed;
    }

    public void setTurnOffSkewed(boolean turnOffSkewed) {
        this.isTurnOffSkewed = turnOffSkewed;
    }

    public List<String> getSkewedColNames() {
        return this.skewedColNames;
    }

    public void setSkewedColNames(List<String> skewedColNames) {
        this.skewedColNames = skewedColNames;
    }

    public List<List<String>> getSkewedColValues() {
        return this.skewedColValues;
    }

    public void setSkewedColValues(List<List<String>> skewedColValues) {
        this.skewedColValues = skewedColValues;
    }

    public void validate() throws SemanticException {
        if (null != this.tableForSkewedColValidation) {
            ValidationUtility.validateSkewedInformation(ParseUtils.validateColumnNameUniqueness(this.tableForSkewedColValidation.getCols()), this.getSkewedColNames(), this.getSkewedColValues());
        }
    }

    public void setTable(Table table) {
        this.tableForSkewedColValidation = table;
    }

    public boolean isStoredAsSubDirectories() {
        return this.isStoredAsSubDirectories;
    }

    public void setStoredAsSubDirectories(boolean isStoredAsSubDirectories) {
        this.isStoredAsSubDirectories = isStoredAsSubDirectories;
    }

    public void setDropIfExists(boolean isDropIfExists) {
        this.isDropIfExists = isDropIfExists;
    }

    public boolean getIsDropIfExists() {
        return this.isDropIfExists;
    }

    public boolean getIsCascade() {
        return this.isCascade;
    }

    public void setIsCascade(boolean isCascade) {
        this.isCascade = isCascade;
    }

    public static boolean doesAlterTableTypeSupportPartialPartitionSpec(AlterTableTypes type) {
        return alterTableTypesWithPartialSpec.contains((Object)type);
    }

    public EnvironmentContext getEnvironmentContext() {
        return this.environmentContext;
    }

    public void setEnvironmentContext(EnvironmentContext environmentContext) {
        this.environmentContext = environmentContext;
    }

    public ReplicationSpec getReplicationSpec() {
        return this.replicationSpec;
    }

    @Override
    public void setWriteId(long writeId) {
        this.writeId = writeId;
    }

    @Override
    public String getFullTableName() {
        return this.getOldName();
    }

    @Override
    public boolean mayNeedWriteId() {
        return this.getOp() == AlterTableTypes.ADDPROPS && AcidUtils.isToInsertOnlyTable(null, this.getProps()) != false;
    }

    public Long getWriteId() {
        return this.writeId;
    }

    static {
        alterTableTypesWithPartialSpec.add(AlterTableTypes.ADDCOLS);
        alterTableTypesWithPartialSpec.add(AlterTableTypes.REPLACECOLS);
        alterTableTypesWithPartialSpec.add(AlterTableTypes.RENAMECOLUMN);
        alterTableTypesWithPartialSpec.add(AlterTableTypes.ADDPROPS);
        alterTableTypesWithPartialSpec.add(AlterTableTypes.DROPPROPS);
        alterTableTypesWithPartialSpec.add(AlterTableTypes.ADDSERDE);
        alterTableTypesWithPartialSpec.add(AlterTableTypes.ADDSERDEPROPS);
        alterTableTypesWithPartialSpec.add(AlterTableTypes.ADDFILEFORMAT);
    }

    public static enum ProtectModeType {
        NO_DROP,
        OFFLINE,
        READ_ONLY,
        NO_DROP_CASCADE;

    }

    public static enum AlterTableTypes {
        RENAME("rename"),
        ADDCOLS("add columns"),
        REPLACECOLS("replace columns"),
        ADDPROPS("add props"),
        DROPPROPS("drop props"),
        ADDSERDE("add serde"),
        ADDSERDEPROPS("add serde props"),
        ADDFILEFORMAT("add fileformat"),
        ADDCLUSTERSORTCOLUMN("add cluster sort column"),
        RENAMECOLUMN("rename column"),
        ADDPARTITION("add partition"),
        TOUCH("touch"),
        ARCHIVE("archieve"),
        UNARCHIVE("unarchieve"),
        ALTERLOCATION("alter location"),
        DROPPARTITION("drop partition"),
        RENAMEPARTITION("rename partition"),
        ADDSKEWEDBY("add skew column"),
        ALTERSKEWEDLOCATION("alter skew location"),
        ALTERBUCKETNUM("alter bucket number"),
        ALTERPARTITION("alter partition"),
        COMPACT("compact"),
        TRUNCATE("truncate"),
        MERGEFILES("merge files"),
        DROPCONSTRAINT("drop constraint"),
        ADDCONSTRAINT("add constraint"),
        UPDATECOLUMNS("update columns"),
        OWNER("set owner");

        private final String name;
        public static final List<AlterTableTypes> nonNativeTableAllowedTypes;

        private AlterTableTypes(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        static {
            nonNativeTableAllowedTypes = ImmutableList.of((Object)((Object)ADDPROPS), (Object)((Object)DROPPROPS), (Object)((Object)ADDCOLS));
        }
    }
}

