/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.resgen;

import java.io.File;
import java.io.PrintWriter;
import org.eigenbase.resgen.AbstractGenerator;
import org.eigenbase.resgen.ResourceDef;
import org.eigenbase.resgen.ResourceDefinition;

abstract class AbstractJavaGenerator
extends AbstractGenerator {
    protected final String className;
    protected final ResourceDef.ResourceBundle resourceBundle;
    protected final String baseClassName;
    private static final String JAVA_STRING = "String";
    private static final String JAVA_NUMBER = "Number";
    private static final String JAVA_DATE_TIME = "java.util.Date";
    private static final String[] JAVA_TYPE_NAMES = new String[]{"String", "Number", "java.util.Date", "java.util.Date"};

    AbstractJavaGenerator(File srcFile, File file, String className, ResourceDef.ResourceBundle resourceBundle, String baseClassName) {
        super(srcFile, file);
        this.className = className;
        this.baseClassName = baseClassName;
        this.resourceBundle = resourceBundle;
    }

    protected String getErrorClass(ResourceDef.Exception exception) {
        if (exception.className != null) {
            return exception.className;
        }
        if (this.resourceBundle.exceptionClassName != null) {
            return this.resourceBundle.exceptionClassName;
        }
        return "java.lang.RuntimeException";
    }

    protected String getPackageName() {
        int lastDot = this.className.lastIndexOf(46);
        if (lastDot < 0) {
            return null;
        }
        return this.className.substring(0, lastDot);
    }

    protected String[] getArgTypes(String message) {
        return ResourceDefinition.getArgTypes(message, JAVA_TYPE_NAMES);
    }

    protected void generateHeader(PrintWriter pw) {
        this.generateDoNotModifyHeader(pw);
        String packageName = this.getPackageName();
        if (packageName != null) {
            pw.println("package " + packageName + ";");
        }
        pw.println("import java.io.IOException;");
        pw.println("import java.util.Locale;");
        pw.println("import java.util.ResourceBundle;");
        pw.println("import org.eigenbase.resgen.*;");
        pw.println();
        this.generateGeneratedByBlock(pw);
    }

    protected void generateFooter(PrintWriter pw, String className) {
        pw.println("// End " + className + ".java");
    }

    protected String getClassName() {
        return this.className;
    }

    protected String getBaseClassName() {
        return this.baseClassName;
    }
}

