/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.backup;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.backup.BackupStatus;
import org.apache.hadoop.hbase.backup.BackupType;
import org.apache.hadoop.hbase.backup.util.BackupClientUtil;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.BackupProtos;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class BackupInfo
implements Comparable<BackupInfo> {
    private static final Log LOG = LogFactory.getLog(BackupInfo.class);
    private String backupId;
    private BackupType type;
    private String targetRootDir;
    private BackupState state;
    private BackupPhase phase;
    private String failedMsg;
    private Map<TableName, BackupStatus> backupStatusMap;
    private long startTs;
    private long endTs;
    private long totalBytesCopied;
    private String hlogTargetDir = null;
    private transient List<String> incrBackupFileList;
    private transient HashMap<TableName, HashMap<String, Long>> tableSetTimestampMap;
    private int progress;
    private String jobId;
    private int workers = -1;
    private long bandwidth = -1L;

    public BackupInfo() {
    }

    public BackupInfo(String backupId, BackupType type, TableName[] tables, String targetRootDir) {
        this.backupStatusMap = new HashMap<TableName, BackupStatus>();
        this.backupId = backupId;
        this.type = type;
        this.targetRootDir = targetRootDir;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("CreateBackupContext: " + tables.length + " " + tables[0]));
        }
        this.addTables(tables);
        if (type == BackupType.INCREMENTAL) {
            this.setHlogTargetDir(BackupClientUtil.getLogBackupDir(targetRootDir, backupId));
        }
        this.startTs = 0L;
        this.endTs = 0L;
    }

    public String getJobId() {
        return this.jobId;
    }

    public void setJobId(String jobId) {
        this.jobId = jobId;
    }

    public int getWorkers() {
        return this.workers;
    }

    public void setWorkers(int workers) {
        this.workers = workers;
    }

    public long getBandwidth() {
        return this.bandwidth;
    }

    public void setBandwidth(long bandwidth) {
        this.bandwidth = bandwidth;
    }

    public void setBackupStatusMap(Map<TableName, BackupStatus> backupStatusMap) {
        this.backupStatusMap = backupStatusMap;
    }

    public HashMap<TableName, HashMap<String, Long>> getTableSetTimestampMap() {
        return this.tableSetTimestampMap;
    }

    public void setTableSetTimestampMap(HashMap<TableName, HashMap<String, Long>> tableSetTimestampMap) {
        this.tableSetTimestampMap = tableSetTimestampMap;
    }

    public String getHlogTargetDir() {
        return this.hlogTargetDir;
    }

    public void setType(BackupType type) {
        this.type = type;
    }

    public void setTargetRootDir(String targetRootDir) {
        this.targetRootDir = targetRootDir;
    }

    public void setTotalBytesCopied(long totalBytesCopied) {
        this.totalBytesCopied = totalBytesCopied;
    }

    public void setProgress(int p) {
        this.progress = p;
    }

    public int getProgress() {
        return this.progress;
    }

    public String getBackupId() {
        return this.backupId;
    }

    public void setBackupId(String backupId) {
        this.backupId = backupId;
    }

    public BackupStatus getBackupStatus(TableName table) {
        return this.backupStatusMap.get(table);
    }

    public String getFailedMsg() {
        return this.failedMsg;
    }

    public void setFailedMsg(String failedMsg) {
        this.failedMsg = failedMsg;
    }

    public long getStartTs() {
        return this.startTs;
    }

    public void setStartTs(long startTs) {
        this.startTs = startTs;
    }

    public long getEndTs() {
        return this.endTs;
    }

    public void setEndTs(long endTs) {
        this.endTs = endTs;
    }

    public long getTotalBytesCopied() {
        return this.totalBytesCopied;
    }

    public BackupState getState() {
        return this.state;
    }

    public void setState(BackupState flag) {
        this.state = flag;
    }

    public BackupPhase getPhase() {
        return this.phase;
    }

    public void setPhase(BackupPhase phase) {
        this.phase = phase;
    }

    public BackupType getType() {
        return this.type;
    }

    public void setSnapshotName(TableName table, String snapshotName) {
        this.backupStatusMap.get(table).setSnapshotName(snapshotName);
    }

    public String getSnapshotName(TableName table) {
        return this.backupStatusMap.get(table).getSnapshotName();
    }

    public List<String> getSnapshotNames() {
        ArrayList<String> snapshotNames = new ArrayList<String>();
        for (BackupStatus backupStatus : this.backupStatusMap.values()) {
            snapshotNames.add(backupStatus.getSnapshotName());
        }
        return snapshotNames;
    }

    public Set<TableName> getTables() {
        return this.backupStatusMap.keySet();
    }

    public List<TableName> getTableNames() {
        return new ArrayList<TableName>(this.backupStatusMap.keySet());
    }

    public void addTables(TableName[] tables) {
        for (TableName table : tables) {
            BackupStatus backupStatus = new BackupStatus(table, this.targetRootDir, this.backupId);
            this.backupStatusMap.put(table, backupStatus);
        }
    }

    public String getTargetRootDir() {
        return this.targetRootDir;
    }

    public void setHlogTargetDir(String hlogTagetDir) {
        this.hlogTargetDir = hlogTagetDir;
    }

    public String getHLogTargetDir() {
        return this.hlogTargetDir;
    }

    public List<String> getIncrBackupFileList() {
        return this.incrBackupFileList;
    }

    public void setIncrBackupFileList(List<String> incrBackupFileList) {
        this.incrBackupFileList = incrBackupFileList;
    }

    public void setIncrTimestampMap(HashMap<TableName, HashMap<String, Long>> newTableSetTimestampMap) {
        this.tableSetTimestampMap = newTableSetTimestampMap;
    }

    public HashMap<TableName, HashMap<String, Long>> getIncrTimestampMap() {
        return this.tableSetTimestampMap;
    }

    public TableName getTableBySnapshot(String snapshotName) {
        for (Map.Entry<TableName, BackupStatus> entry : this.backupStatusMap.entrySet()) {
            if (!snapshotName.equals(entry.getValue().getSnapshotName())) continue;
            return entry.getKey();
        }
        return null;
    }

    public BackupProtos.BackupInfo toProtosBackupInfo() {
        BackupProtos.BackupInfo.Builder builder = BackupProtos.BackupInfo.newBuilder();
        builder.setBackupId(this.getBackupId());
        this.setBackupStatusMap(builder);
        builder.setEndTs(this.getEndTs());
        if (this.getFailedMsg() != null) {
            builder.setFailedMessage(this.getFailedMsg());
        }
        if (this.getState() != null) {
            builder.setState(BackupProtos.BackupInfo.BackupState.valueOf((String)this.getState().name()));
        }
        if (this.getPhase() != null) {
            builder.setPhase(BackupProtos.BackupInfo.BackupPhase.valueOf((String)this.getPhase().name()));
        }
        builder.setProgress(this.getProgress());
        builder.setStartTs(this.getStartTs());
        builder.setTargetRootDir(this.getTargetRootDir());
        builder.setType(BackupProtos.BackupType.valueOf((String)this.getType().name()));
        builder.setWorkersNumber(this.workers);
        builder.setBandwidth(this.bandwidth);
        if (this.jobId != null) {
            builder.setJobId(this.jobId);
        }
        return builder.build();
    }

    public byte[] toByteArray() throws IOException {
        return this.toProtosBackupInfo().toByteArray();
    }

    private void setBackupStatusMap(BackupProtos.BackupInfo.Builder builder) {
        for (Map.Entry<TableName, BackupStatus> entry : this.backupStatusMap.entrySet()) {
            builder.addTableBackupStatus(entry.getValue().toProto());
        }
    }

    public static BackupInfo fromByteArray(byte[] data) throws IOException {
        return BackupInfo.fromProto(BackupProtos.BackupInfo.parseFrom((byte[])data));
    }

    public static BackupInfo fromStream(InputStream stream) throws IOException {
        return BackupInfo.fromProto(BackupProtos.BackupInfo.parseDelimitedFrom((InputStream)stream));
    }

    public static BackupInfo fromProto(BackupProtos.BackupInfo proto) {
        BackupInfo context = new BackupInfo();
        context.setBackupId(proto.getBackupId());
        context.setBackupStatusMap(BackupInfo.toMap(proto.getTableBackupStatusList()));
        context.setEndTs(proto.getEndTs());
        if (proto.hasFailedMessage()) {
            context.setFailedMsg(proto.getFailedMessage());
        }
        if (proto.hasState()) {
            context.setState(BackupState.valueOf(proto.getState().name()));
        }
        context.setHlogTargetDir(BackupClientUtil.getLogBackupDir(proto.getTargetRootDir(), proto.getBackupId()));
        if (proto.hasPhase()) {
            context.setPhase(BackupPhase.valueOf(proto.getPhase().name()));
        }
        if (proto.hasProgress()) {
            context.setProgress(proto.getProgress());
        }
        context.setStartTs(proto.getStartTs());
        context.setTargetRootDir(proto.getTargetRootDir());
        context.setType(BackupType.valueOf((String)proto.getType().name()));
        context.setWorkers(proto.getWorkersNumber());
        context.setBandwidth(proto.getBandwidth());
        if (proto.hasJobId()) {
            context.setJobId(proto.getJobId());
        }
        return context;
    }

    private static Map<TableName, BackupStatus> toMap(List<BackupProtos.TableBackupStatus> list) {
        HashMap<TableName, BackupStatus> map = new HashMap<TableName, BackupStatus>();
        for (BackupProtos.TableBackupStatus tbs : list) {
            map.put(ProtobufUtil.toTableName(tbs.getTable()), BackupStatus.convert(tbs));
        }
        return map;
    }

    public String getShortDescription() {
        StringBuilder sb = new StringBuilder();
        sb.append("ID             : " + this.backupId).append("\n");
        sb.append("Type           : " + this.getType()).append("\n");
        sb.append("Tables         : " + this.getTableListAsString()).append("\n");
        sb.append("State          : " + (Object)((Object)this.getState())).append("\n");
        Date date = null;
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(this.getStartTs());
        date = cal.getTime();
        sb.append("Start time     : " + date).append("\n");
        if (this.state == BackupState.FAILED) {
            sb.append("Failed message : " + this.getFailedMsg()).append("\n");
        } else if (this.state == BackupState.RUNNING) {
            sb.append("Phase          : " + (Object)((Object)this.getPhase())).append("\n");
        } else if (this.state == BackupState.COMPLETE) {
            cal = Calendar.getInstance();
            cal.setTimeInMillis(this.getEndTs());
            date = cal.getTime();
            sb.append("End time       : " + date).append("\n");
        }
        sb.append("Progress       : " + this.getProgress()).append("\n");
        return sb.toString();
    }

    public String getStatusAndProgressAsString() {
        StringBuilder sb = new StringBuilder();
        sb.append("id: ").append(this.getBackupId()).append(" state: ").append((Object)this.getState()).append(" progress: ").append(this.getProgress());
        return sb.toString();
    }

    public String getTableListAsString() {
        return StringUtils.join(this.backupStatusMap.keySet(), (String)",");
    }

    @Override
    public int compareTo(BackupInfo o) {
        Long thisTS = new Long(this.getBackupId().substring(this.getBackupId().lastIndexOf("_") + 1));
        Long otherTS = new Long(o.getBackupId().substring(o.getBackupId().lastIndexOf("_") + 1));
        return thisTS.compareTo(otherTS);
    }

    public static enum BackupPhase {
        SNAPSHOTCOPY,
        INCREMENTAL_COPY,
        STORE_MANIFEST;

    }

    public static enum BackupState {
        WAITING,
        RUNNING,
        COMPLETE,
        FAILED,
        ANY;

    }
}

