/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.annotation;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.pentaho.agilebi.modeler.models.annotations.AnnotationType;
import org.pentaho.agilebi.modeler.models.annotations.ModelAnnotation;
import org.pentaho.agilebi.modeler.models.annotations.ModelAnnotationGroup;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.util.StringUtil;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.steps.annotation.ModelAnnotationMeta;

public class SharedDimensionGroupValidation {
    private static Class<?> PKG = ModelAnnotationMeta.class;
    private Set<String> msgs = new LinkedHashSet<String>();
    private LogChannelInterface log;

    public SharedDimensionGroupValidation(ModelAnnotationGroup targetGroup, LogChannelInterface log) {
        this.log = log;
        try {
            this.validateSharedDimension(targetGroup);
        }
        catch (Exception e) {
            log.logError(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public boolean hasErrors() {
        return !this.msgs.isEmpty();
    }

    public Collection<String> getErrorSummary() {
        return this.msgs;
    }

    private void validateSharedDimension(ModelAnnotationGroup annotations) {
        if (!annotations.isSharedDimension() || StringUtil.isVariable((String)annotations.getName())) {
            return;
        }
        int keyCount = 0;
        String dimension = null;
        block5: for (ModelAnnotation annotation : annotations) {
            if (annotation.getType() == null) {
                this.addError(annotation, BaseMessages.getString(PKG, (String)"ModelAnnotation.SharedDimension.ValidationError.WrongAnnotationType", (String[])new String[0]));
                continue;
            }
            switch (annotation.getType()) {
                case CREATE_DIMENSION_KEY: {
                    if (++keyCount > 1) {
                        this.addError(annotation, BaseMessages.getString(PKG, (String)"ModelAnnotation.SharedDimension.ValidationError.OneKeyOnly", (String[])new String[0]));
                    }
                }
                case CREATE_ATTRIBUTE: {
                    dimension = this.validateDimension(dimension, annotation);
                    continue block5;
                }
                case BLANK: {
                    continue block5;
                }
            }
            this.addError(annotation, BaseMessages.getString(PKG, (String)"ModelAnnotation.SharedDimension.ValidationError.WrongAnnotationType", (String[])new String[0]));
        }
        if (keyCount == 0) {
            this.addError(null, BaseMessages.getString(PKG, (String)"ModelAnnotation.SharedDimension.ValidationError.NoKey", (String[])new String[0]));
        }
    }

    private String validateDimension(String dimension, ModelAnnotation<?> annotation) {
        try {
            String currDim = this.getDimension(annotation.getAnnotation());
            if (StringUtils.isBlank((String)dimension)) {
                dimension = currDim;
            } else if (!StringUtils.equals((String)dimension, (String)currDim)) {
                this.addError(annotation, BaseMessages.getString(PKG, (String)"ModelAnnotation.SharedDimension.ValidationError.DimensionMismatch", (String[])new String[0]));
            }
        }
        catch (Exception e) {
            this.log.logError(e.getLocalizedMessage(), (Throwable)e);
        }
        return dimension;
    }

    private String getDimension(AnnotationType annotationType) throws Exception {
        return (String)annotationType.getModelPropertyValueById("dimension");
    }

    private void addError(ModelAnnotation<?> annotation, String summary) {
        this.msgs.add(summary);
    }
}

