/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.fonts.afm;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.libraries.base.util.StringUtils;
import org.pentaho.reporting.libraries.fonts.afm.AfmFont;
import org.pentaho.reporting.libraries.fonts.afm.AfmFontRecord;
import org.pentaho.reporting.libraries.fonts.cache.FontCache;
import org.pentaho.reporting.libraries.fonts.registry.AbstractFontFileRegistry;
import org.pentaho.reporting.libraries.fonts.registry.DefaultFontFamily;
import org.pentaho.reporting.libraries.fonts.registry.FontMetricsFactory;

public class AfmFontRegistry
extends AbstractFontFileRegistry {
    private static final Log logger = LogFactory.getLog(AfmFontRegistry.class);
    private static final FontPathFilter FONTPATHFILTER = new FontPathFilter();

    @Override
    protected FileFilter getFileFilter() {
        return FONTPATHFILTER;
    }

    @Override
    public FontMetricsFactory createMetricsFactory() {
        throw new UnsupportedOperationException();
    }

    @Override
    public FontCache getSecondLevelCache() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addFont(File font, String encoding) throws IOException {
        String fileName = font.getCanonicalPath();
        String filePfbName = fileName.substring(0, fileName.length() - 3) + "pfb";
        File filePfb = new File(filePfbName);
        boolean embedded = true;
        if (!(filePfb.exists() && filePfb.isFile() && filePfb.canRead())) {
            logger.warn((Object)("Cannot embedd font: " + filePfb + " is missing for " + font));
            embedded = false;
        }
        AfmFont pfmFont = new AfmFont(font, embedded);
        this.registerFont(pfmFont);
        pfmFont.dispose();
        return true;
    }

    private void registerFont(AfmFont font) throws IOException {
        String windowsName = font.getFamilyName();
        String postscriptName = font.getFontName();
        DefaultFontFamily fontFamily = this.createFamily(windowsName);
        fontFamily.addFontRecord(new AfmFontRecord(font, fontFamily));
        this.registerPrimaryName(windowsName, fontFamily);
        this.registerAlternativeName(windowsName, fontFamily);
        this.registerAlternativeName(postscriptName, fontFamily);
        this.registerFullName(windowsName, fontFamily);
        this.registerFullName(postscriptName, fontFamily);
    }

    @Override
    protected String getCacheFileName() {
        return "afm-fontcache.ser";
    }

    private static class FontPathFilter
    implements FileFilter {
        protected FontPathFilter() {
        }

        @Override
        public boolean accept(File pathname) {
            if (!pathname.canRead()) {
                return false;
            }
            if (pathname.isDirectory()) {
                return true;
            }
            String name = pathname.getName();
            return StringUtils.endsWithIgnoreCase((String)name, (String)".afm");
        }
    }
}

