/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.fonts.itext;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.libraries.base.util.ArgumentNullException;
import org.pentaho.reporting.libraries.fonts.cache.FirstLevelFontCache;
import org.pentaho.reporting.libraries.fonts.encoding.EncodingRegistry;
import org.pentaho.reporting.libraries.fonts.itext.ITextFontMetricsFactory;
import org.pentaho.reporting.libraries.fonts.itext.ITextFontRegistry;
import org.pentaho.reporting.libraries.fonts.registry.FontContext;
import org.pentaho.reporting.libraries.fonts.registry.FontIdentifier;
import org.pentaho.reporting.libraries.fonts.registry.FontKey;
import org.pentaho.reporting.libraries.fonts.registry.FontMetrics;
import org.pentaho.reporting.libraries.fonts.registry.FontRegistry;
import org.pentaho.reporting.libraries.fonts.registry.FontStorage;

public class ITextFontStorage
implements FontStorage {
    private static final Log logger = LogFactory.getLog(ITextFontStorage.class);
    private ITextFontRegistry registry;
    private ITextFontMetricsFactory metricsFactory;
    private EncodingFontKey lookupKey;
    private FirstLevelFontCache knownMetrics;
    private String defaultEncoding;
    private int hits;
    private int misses;

    public ITextFontStorage(ITextFontRegistry registry) {
        this(registry, EncodingRegistry.getPlatformDefaultEncoding());
    }

    public ITextFontStorage(ITextFontRegistry registry, String encoding) {
        ArgumentNullException.validate((String)"registry", (Object)registry);
        ArgumentNullException.validate((String)"encoding", (Object)encoding);
        this.lookupKey = new EncodingFontKey();
        this.knownMetrics = new FirstLevelFontCache(registry.getSecondLevelCache());
        this.registry = registry;
        this.defaultEncoding = encoding;
        this.metricsFactory = (ITextFontMetricsFactory)registry.createMetricsFactory();
    }

    public String getDefaultEncoding() {
        return this.defaultEncoding;
    }

    public void setDefaultEncoding(String defaultEncoding) {
        ArgumentNullException.validate((String)"defaultEncoding", (Object)defaultEncoding);
        this.defaultEncoding = defaultEncoding;
    }

    @Override
    public FontRegistry getFontRegistry() {
        return this.registry;
    }

    @Override
    public FontMetrics getFontMetrics(FontIdentifier rawRecord, FontContext context) {
        if (rawRecord == null) {
            throw new NullPointerException();
        }
        if (context == null) {
            throw new NullPointerException();
        }
        String contextEncoding = context.getEncoding();
        String effectiveEncoding = contextEncoding == null ? this.defaultEncoding : contextEncoding;
        this.lookupKey.setAliased(context.isAntiAliased());
        this.lookupKey.setFontSize(context.getFontSize());
        this.lookupKey.setIdentifier(rawRecord);
        this.lookupKey.setFractional(context.isFractionalMetrics());
        this.lookupKey.setEncoding(effectiveEncoding);
        FontMetrics cachedMetrics = this.knownMetrics.getFontMetrics(this.lookupKey);
        if (cachedMetrics != null) {
            ++this.hits;
            return cachedMetrics;
        }
        ++this.misses;
        EncodingFontContextWrapper contextWrapper = new EncodingFontContextWrapper(context, effectiveEncoding);
        FontMetrics metrics = this.metricsFactory.createMetrics(rawRecord, contextWrapper);
        EncodingFontKey key = new EncodingFontKey(rawRecord, context.isAntiAliased(), context.isFractionalMetrics(), context.getFontSize(), effectiveEncoding);
        this.knownMetrics.putFontMetrics(key, metrics);
        return metrics;
    }

    @Override
    public void commit() {
        logger.debug((Object)("Font-Storage: hits=" + this.hits + ", misses=" + this.misses));
        this.metricsFactory.close();
        this.knownMetrics.commit();
    }

    private static class EncodingFontKey
    extends FontKey {
        private String encoding;

        public EncodingFontKey(FontIdentifier identifier, boolean aliased, boolean fractional, double fontSize, String encoding) {
            super(identifier, aliased, fractional, fontSize);
            this.encoding = encoding;
        }

        public EncodingFontKey() {
        }

        public String getEncoding() {
            return this.encoding;
        }

        public void setEncoding(String encoding) {
            this.encoding = encoding;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            EncodingFontKey that = (EncodingFontKey)o;
            return !(this.encoding != null ? !this.encoding.equals(that.encoding) : that.encoding != null);
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + (this.encoding != null ? this.encoding.hashCode() : 0);
            return result;
        }
    }

    private static class EncodingFontContextWrapper
    implements FontContext {
        private FontContext context;
        private String defaultEncoding;

        private EncodingFontContextWrapper(FontContext context, String defaultEncoding) {
            this.context = context;
            this.defaultEncoding = defaultEncoding;
        }

        @Override
        public String getEncoding() {
            return this.defaultEncoding;
        }

        @Override
        public boolean isEmbedded() {
            return this.context.isEmbedded();
        }

        @Override
        public boolean isAntiAliased() {
            return this.context.isAntiAliased();
        }

        @Override
        public boolean isFractionalMetrics() {
            return this.context.isFractionalMetrics();
        }

        @Override
        public double getFontSize() {
            return this.context.getFontSize();
        }
    }
}

