/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.charset;

import com.ibm.icu.charset.CharsetICU;
import com.ibm.icu.charset.CharsetMBCS;
import com.ibm.icu.charset.UConverterAlias;
import com.ibm.icu.impl.InvalidFormatException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.nio.charset.spi.CharsetProvider;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CharsetProviderICU
extends CharsetProvider {
    private String optionsString = null;

    @Override
    public final Charset charsetForName(String charsetName) {
        try {
            charsetName = this.processOptions(charsetName);
            String icuCanonicalName = CharsetProviderICU.getICUCanonicalName(charsetName);
            if (icuCanonicalName == null || icuCanonicalName.length() == 0) {
                return this.getCharset(charsetName);
            }
            return this.getCharset(icuCanonicalName);
        }
        catch (UnsupportedCharsetException ex) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public final Charset charsetForName(String charsetName, String classPath) {
        return this.charsetForName(charsetName, classPath, null);
    }

    public Charset charsetForName(String charsetName, String classPath, ClassLoader loader) {
        CharsetMBCS cs = null;
        try {
            cs = new CharsetMBCS(charsetName, charsetName, new String[0], classPath, loader);
        }
        catch (InvalidFormatException e) {
            // empty catch block
        }
        return cs;
    }

    @Deprecated
    public static final String getICUCanonicalName(String enc) throws UnsupportedCharsetException {
        String canonicalName = null;
        String ret = null;
        try {
            if (enc != null) {
                canonicalName = UConverterAlias.getCanonicalName(enc, "MIME");
                ret = canonicalName != null ? canonicalName : ((canonicalName = UConverterAlias.getCanonicalName(enc, "IANA")) != null ? canonicalName : ((canonicalName = UConverterAlias.getAlias(enc, 0)) != null ? canonicalName : (enc.indexOf("x-") == 0 || enc.indexOf("X-") == 0 ? ((canonicalName = UConverterAlias.getAlias(enc.substring(2), 0)) != null ? canonicalName : "") : "")));
            }
            return ret;
        }
        catch (IOException ex) {
            throw new UnsupportedCharsetException(enc);
        }
    }

    private Charset getCharset(String icuCanonicalName) throws IOException {
        String[] aliases = CharsetProviderICU.getAliases(icuCanonicalName);
        String canonicalName = CharsetProviderICU.getJavaCanonicalName(icuCanonicalName);
        if (this.optionsString != null) {
            icuCanonicalName = icuCanonicalName.concat(this.optionsString);
            this.optionsString = null;
        }
        return CharsetICU.getCharset(icuCanonicalName, canonicalName, aliases);
    }

    @Deprecated
    public static String getJavaCanonicalName(String charsetName) {
        if (charsetName == null) {
            return null;
        }
        try {
            String cName = null;
            cName = UConverterAlias.getStandardName(charsetName, "MIME");
            if (cName == null && (cName = UConverterAlias.getStandardName(charsetName, "IANA")) == null) {
                String name;
                int aliasNum = UConverterAlias.countAliases(charsetName);
                for (int i = 0; i < aliasNum; ++i) {
                    name = UConverterAlias.getAlias(charsetName, i);
                    if (name == null || name.indexOf("x-") != 0) continue;
                    cName = name;
                    break;
                }
                if (cName == null || cName.length() == 0) {
                    name = UConverterAlias.getStandardName(charsetName, "UTR22");
                    if (name == null && charsetName.indexOf(",") != -1) {
                        name = UConverterAlias.getAlias(charsetName, 1);
                    }
                    if (name == null) {
                        name = charsetName;
                    }
                    cName = "x-" + name;
                }
            }
            if (cName != null) {
                try {
                    String testName;
                    if (Charset.isSupported(cName) && !(testName = Charset.forName(cName).name()).equals(cName) && CharsetProviderICU.getICUCanonicalName(testName).length() > 0) {
                        cName = testName;
                    }
                }
                catch (Exception e) {
                    cName = null;
                }
            }
            return cName;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Deprecated
    private static final String[] getAliases(String encName) throws IOException {
        String[] ret = null;
        int aliasNum = 0;
        int i = 0;
        int j = 0;
        String[] aliasArray = new String[50];
        if (encName != null) {
            aliasNum = UConverterAlias.countAliases(encName);
            j = 0;
            for (i = 0; i < aliasNum; ++i) {
                String name = UConverterAlias.getAlias(encName, i);
                if (name.indexOf(43) != -1 || name.indexOf(44) != -1) continue;
                aliasArray[j++] = name;
            }
            ret = new String[j];
            while (--j >= 0) {
                ret[j] = aliasArray[j];
            }
        }
        return ret;
    }

    private void putCharsets(Map<Charset, String> map) {
        int num = UConverterAlias.countAvailable();
        for (int i = 0; i < num; ++i) {
            String name = UConverterAlias.getAvailableName(i);
            try {
                Charset cs = this.getCharset(name);
                map.put(cs, CharsetProviderICU.getJavaCanonicalName(name));
                continue;
            }
            catch (UnsupportedCharsetException ex) {
                continue;
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }

    @Override
    public final Iterator<Charset> charsets() {
        HashMap<Charset, String> map = new HashMap<Charset, String>();
        this.putCharsets(map);
        return map.keySet().iterator();
    }

    @Deprecated
    public static final String[] getAvailableNames() {
        CharsetProviderICU provider = new CharsetProviderICU();
        HashMap<Charset, String> map = new HashMap<Charset, String>();
        provider.putCharsets(map);
        return map.values().toArray(new String[0]);
    }

    @Deprecated
    public static final String[] getAllNames() {
        int num = UConverterAlias.countAvailable();
        String[] names = new String[num];
        for (int i = 0; i < num; ++i) {
            names[i] = UConverterAlias.getAvailableName(i);
        }
        return names;
    }

    private String processOptions(String charsetName) {
        if (charsetName.indexOf(",swaplfnl") > -1) {
            this.optionsString = ",swaplfnl";
            charsetName = charsetName.substring(0, charsetName.indexOf(",swaplfnl"));
        }
        return charsetName;
    }
}

