/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector;

import java.io.IOException;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.common.type.HiveChar;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.common.type.HiveIntervalDayTime;
import org.apache.hadoop.hive.common.type.HiveIntervalYearMonth;
import org.apache.hadoop.hive.common.type.HiveVarchar;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DecimalColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.IntervalDayTimeColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.TimestampColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.serde2.io.DateWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableHiveCharObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableHiveDecimalObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableHiveVarcharObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.CharTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.hive.serde2.typeinfo.VarcharTypeInfo;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.Text;

public abstract class VectorExtractRow {
    private static final long serialVersionUID = 1L;
    private static final Log LOG = LogFactory.getLog(VectorExtractRow.class);
    private boolean tolerateNullColumns = true;
    Extractor[] extracters;

    private Extractor createExtractor(PrimitiveTypeInfo primitiveTypeInfo, int columnIndex) throws HiveException {
        Extractor extracter;
        PrimitiveObjectInspector.PrimitiveCategory primitiveCategory = primitiveTypeInfo.getPrimitiveCategory();
        switch (primitiveCategory) {
            case VOID: {
                extracter = new VoidExtractor(columnIndex);
                break;
            }
            case BOOLEAN: {
                extracter = new BooleanExtractor(columnIndex);
                break;
            }
            case BYTE: {
                extracter = new ByteExtractor(columnIndex);
                break;
            }
            case SHORT: {
                extracter = new ShortExtractor(columnIndex);
                break;
            }
            case INT: {
                extracter = new IntExtractor(columnIndex);
                break;
            }
            case LONG: {
                extracter = new LongExtractor(columnIndex);
                break;
            }
            case TIMESTAMP: {
                extracter = new TimestampExtractor(columnIndex);
                break;
            }
            case DATE: {
                extracter = new DateExtractor(columnIndex);
                break;
            }
            case FLOAT: {
                extracter = new FloatExtractor(columnIndex);
                break;
            }
            case DOUBLE: {
                extracter = new DoubleExtractor(columnIndex);
                break;
            }
            case BINARY: {
                extracter = new BinaryExtractorByValue(columnIndex);
                break;
            }
            case STRING: {
                extracter = new StringExtractorByValue(columnIndex);
                break;
            }
            case VARCHAR: {
                extracter = new VarCharExtractorByValue((VarcharTypeInfo)primitiveTypeInfo, columnIndex);
                break;
            }
            case CHAR: {
                extracter = new CharExtractorByValue((CharTypeInfo)primitiveTypeInfo, columnIndex);
                break;
            }
            case DECIMAL: {
                extracter = new DecimalExtractor((DecimalTypeInfo)primitiveTypeInfo, columnIndex);
                break;
            }
            case INTERVAL_YEAR_MONTH: {
                extracter = new IntervalYearMonthExtractor(columnIndex);
                break;
            }
            case INTERVAL_DAY_TIME: {
                extracter = new IntervalDayTimeExtractor(columnIndex);
                break;
            }
            default: {
                throw new HiveException("No vector row extracter for primitive category " + (Object)((Object)primitiveCategory));
            }
        }
        return extracter;
    }

    public void init(StructObjectInspector structObjectInspector, List<Integer> projectedColumns) throws HiveException {
        this.extracters = new Extractor[projectedColumns.size()];
        List<? extends StructField> fields = structObjectInspector.getAllStructFieldRefs();
        int i = 0;
        for (StructField structField : fields) {
            int columnIndex = projectedColumns.get(i);
            ObjectInspector fieldInspector = structField.getFieldObjectInspector();
            TypeInfo typeInfo = TypeInfoUtils.getTypeInfoFromTypeString(fieldInspector.getTypeName());
            if (typeInfo.getCategory() == ObjectInspector.Category.PRIMITIVE) {
                PrimitiveTypeInfo primitiveTypeInfo = (PrimitiveTypeInfo)typeInfo;
                this.extracters[i] = this.createExtractor(primitiveTypeInfo, columnIndex);
            } else {
                this.extracters[i] = new VoidExtractor(columnIndex);
            }
            ++i;
        }
    }

    public void init(List<String> typeNames) throws HiveException {
        this.extracters = new Extractor[typeNames.size()];
        int i = 0;
        for (String typeName : typeNames) {
            PrimitiveTypeInfo primitiveTypeInfo = (PrimitiveTypeInfo)TypeInfoUtils.getTypeInfoFromTypeString(typeName);
            this.extracters[i] = this.createExtractor(primitiveTypeInfo, i);
            ++i;
        }
    }

    public int getCount() {
        return this.extracters.length;
    }

    protected void setBatch(VectorizedRowBatch batch) throws HiveException {
        for (int i = 0; i < this.extracters.length; ++i) {
            Extractor extracter = this.extracters[i];
            int columnIndex = extracter.getColumnIndex();
            if (batch.cols[columnIndex] == null) {
                if (this.tolerateNullColumns) {
                    this.extracters[i] = extracter = new VoidExtractor(columnIndex);
                } else {
                    throw new HiveException("Unexpected null vector column " + columnIndex);
                }
            }
            extracter.setColumnVector(batch);
        }
    }

    protected void forgetBatch() {
        for (Extractor extracter : this.extracters) {
            extracter.forgetColumnVector();
        }
    }

    public Object extractRowColumn(int batchIndex, int logicalColumnIndex) {
        return this.extracters[logicalColumnIndex].extract(batchIndex);
    }

    public void extractRow(int batchIndex, Object[] objects) {
        for (int i = 0; i < this.extracters.length; ++i) {
            Extractor extracter = this.extracters[i];
            objects[i] = extracter.extract(batchIndex);
        }
    }

    private class DecimalExtractor
    extends Extractor {
        private WritableHiveDecimalObjectInspector writableDecimalObjectInspector;
        protected DecimalColumnVector colVector;

        DecimalExtractor(DecimalTypeInfo decimalTypeInfo, int columnIndex) {
            super(columnIndex);
            this.writableDecimalObjectInspector = new WritableHiveDecimalObjectInspector(decimalTypeInfo);
            this.object = this.writableDecimalObjectInspector.create(HiveDecimal.ZERO);
        }

        @Override
        void setColumnVector(VectorizedRowBatch batch) {
            this.colVector = (DecimalColumnVector)batch.cols[this.columnIndex];
        }

        @Override
        void forgetColumnVector() {
            this.colVector = null;
        }

        @Override
        Object extract(int batchIndex) {
            int adjustedIndex;
            int n = adjustedIndex = this.colVector.isRepeating ? 0 : batchIndex;
            if (this.colVector.noNulls || !this.colVector.isNull[adjustedIndex]) {
                HiveDecimal value = this.colVector.vector[adjustedIndex].getHiveDecimal();
                this.writableDecimalObjectInspector.set(this.object, value);
                return this.object;
            }
            return null;
        }
    }

    private class CharExtractorByValue
    extends AbstractBytesExtractor {
        private WritableHiveCharObjectInspector writableCharObjectInspector;
        private Text text;

        CharExtractorByValue(CharTypeInfo charTypeInfo, int columnIndex) {
            super(columnIndex);
            this.writableCharObjectInspector = new WritableHiveCharObjectInspector(charTypeInfo);
            this.object = this.writableCharObjectInspector.create(new HiveChar("", -1));
            this.text = new Text();
        }

        @Override
        Object extract(int batchIndex) {
            int adjustedIndex;
            int n = adjustedIndex = this.colVector.isRepeating ? 0 : batchIndex;
            if (this.colVector.noNulls || !this.colVector.isNull[adjustedIndex]) {
                byte[] value = this.colVector.vector[adjustedIndex];
                int start = this.colVector.start[adjustedIndex];
                int length = this.colVector.length[adjustedIndex];
                this.text.set(value, start, length);
                this.writableCharObjectInspector.set(this.object, this.text.toString());
                return this.object;
            }
            return null;
        }
    }

    private class VarCharExtractorByValue
    extends AbstractBytesExtractor {
        private WritableHiveVarcharObjectInspector writableVarcharObjectInspector;
        private Text text;

        VarCharExtractorByValue(VarcharTypeInfo varcharTypeInfo, int columnIndex) {
            super(columnIndex);
            this.writableVarcharObjectInspector = new WritableHiveVarcharObjectInspector(varcharTypeInfo);
            this.object = this.writableVarcharObjectInspector.create(new HiveVarchar("", -1));
            this.text = new Text();
        }

        @Override
        Object extract(int batchIndex) {
            int adjustedIndex;
            int n = adjustedIndex = this.colVector.isRepeating ? 0 : batchIndex;
            if (this.colVector.noNulls || !this.colVector.isNull[adjustedIndex]) {
                byte[] value = this.colVector.vector[adjustedIndex];
                int start = this.colVector.start[adjustedIndex];
                int length = this.colVector.length[adjustedIndex];
                this.text.set(value, start, length);
                this.writableVarcharObjectInspector.set(this.object, this.text.toString());
                return this.object;
            }
            return null;
        }
    }

    private class StringExtractorByValue
    extends AbstractBytesExtractor {
        private Text text;

        StringExtractorByValue(int columnIndex) {
            super(columnIndex);
            this.object = PrimitiveObjectInspectorFactory.writableStringObjectInspector.create("");
            this.text = new Text();
        }

        @Override
        Object extract(int batchIndex) {
            int adjustedIndex;
            int n = adjustedIndex = this.colVector.isRepeating ? 0 : batchIndex;
            if (this.colVector.noNulls || !this.colVector.isNull[adjustedIndex]) {
                byte[] value = this.colVector.vector[adjustedIndex];
                int start = this.colVector.start[adjustedIndex];
                int length = this.colVector.length[adjustedIndex];
                if (value == null) {
                    LOG.info((Object)("null string entry: batchIndex " + batchIndex + " columnIndex " + this.columnIndex));
                }
                this.text.set(value, start, length);
                PrimitiveObjectInspectorFactory.writableStringObjectInspector.set(this.object, this.text);
                return this.object;
            }
            return null;
        }
    }

    private class BinaryExtractorByValue
    extends AbstractBytesExtractor {
        private DataOutputBuffer buffer;
        private BytesWritable bytesWritable;

        BinaryExtractorByValue(int columnIndex) {
            super(columnIndex);
            this.object = PrimitiveObjectInspectorFactory.writableBinaryObjectInspector.create(ArrayUtils.EMPTY_BYTE_ARRAY);
            this.buffer = new DataOutputBuffer();
            this.bytesWritable = new BytesWritable();
        }

        @Override
        Object extract(int batchIndex) {
            int adjustedIndex;
            int n = adjustedIndex = this.colVector.isRepeating ? 0 : batchIndex;
            if (this.colVector.noNulls || !this.colVector.isNull[adjustedIndex]) {
                byte[] bytes = this.colVector.vector[adjustedIndex];
                int start = this.colVector.start[adjustedIndex];
                int length = this.colVector.length[adjustedIndex];
                this.buffer.reset();
                try {
                    this.buffer.write(bytes, start, length);
                }
                catch (IOException ioe) {
                    throw new IllegalStateException("bad write", ioe);
                }
                this.bytesWritable.set(this.buffer.getData(), 0, this.buffer.getLength());
                PrimitiveObjectInspectorFactory.writableBinaryObjectInspector.set(this.object, this.bytesWritable);
                return this.object;
            }
            return null;
        }
    }

    private abstract class AbstractBytesExtractor
    extends Extractor {
        protected BytesColumnVector colVector;

        AbstractBytesExtractor(int columnIndex) {
            super(columnIndex);
        }

        @Override
        void setColumnVector(VectorizedRowBatch batch) {
            this.colVector = (BytesColumnVector)batch.cols[this.columnIndex];
        }

        @Override
        void forgetColumnVector() {
            this.colVector = null;
        }
    }

    private class DoubleExtractor
    extends AbstractDoubleExtractor {
        DoubleExtractor(int columnIndex) {
            super(columnIndex);
            this.object = PrimitiveObjectInspectorFactory.writableDoubleObjectInspector.create(0.0);
        }

        @Override
        Object extract(int batchIndex) {
            int adjustedIndex;
            int n = adjustedIndex = this.colVector.isRepeating ? 0 : batchIndex;
            if (this.colVector.noNulls || !this.colVector.isNull[adjustedIndex]) {
                double value = this.vector[adjustedIndex];
                PrimitiveObjectInspectorFactory.writableDoubleObjectInspector.set(this.object, value);
                return this.object;
            }
            return null;
        }
    }

    private class FloatExtractor
    extends AbstractDoubleExtractor {
        FloatExtractor(int columnIndex) {
            super(columnIndex);
            this.object = PrimitiveObjectInspectorFactory.writableFloatObjectInspector.create(0.0f);
        }

        @Override
        Object extract(int batchIndex) {
            int adjustedIndex;
            int n = adjustedIndex = this.colVector.isRepeating ? 0 : batchIndex;
            if (this.colVector.noNulls || !this.colVector.isNull[adjustedIndex]) {
                double value = this.vector[adjustedIndex];
                PrimitiveObjectInspectorFactory.writableFloatObjectInspector.set(this.object, (float)value);
                return this.object;
            }
            return null;
        }
    }

    private abstract class AbstractDoubleExtractor
    extends Extractor {
        protected DoubleColumnVector colVector;
        protected double[] vector;

        AbstractDoubleExtractor(int columnIndex) {
            super(columnIndex);
        }

        @Override
        void setColumnVector(VectorizedRowBatch batch) {
            this.colVector = (DoubleColumnVector)batch.cols[this.columnIndex];
            this.vector = this.colVector.vector;
        }

        @Override
        void forgetColumnVector() {
            this.colVector = null;
            this.vector = null;
        }
    }

    private class IntervalDayTimeExtractor
    extends AbstractIntervalDayTimeExtractor {
        private HiveIntervalDayTime hiveIntervalDayTime;

        IntervalDayTimeExtractor(int columnIndex) {
            super(columnIndex);
            this.object = PrimitiveObjectInspectorFactory.writableHiveIntervalDayTimeObjectInspector.create(new HiveIntervalDayTime(0L, 0));
            this.hiveIntervalDayTime = new HiveIntervalDayTime(0L, 0);
        }

        @Override
        Object extract(int batchIndex) {
            int adjustedIndex;
            int n = adjustedIndex = this.colVector.isRepeating ? 0 : batchIndex;
            if (this.colVector.noNulls || !this.colVector.isNull[adjustedIndex]) {
                this.hiveIntervalDayTime.set(this.colVector.asScratchIntervalDayTime(adjustedIndex));
                PrimitiveObjectInspectorFactory.writableHiveIntervalDayTimeObjectInspector.set(this.object, this.hiveIntervalDayTime);
                return this.object;
            }
            return null;
        }
    }

    private abstract class AbstractIntervalDayTimeExtractor
    extends Extractor {
        protected IntervalDayTimeColumnVector colVector;

        AbstractIntervalDayTimeExtractor(int columnIndex) {
            super(columnIndex);
        }

        @Override
        void setColumnVector(VectorizedRowBatch batch) {
            this.colVector = (IntervalDayTimeColumnVector)batch.cols[this.columnIndex];
        }

        @Override
        void forgetColumnVector() {
            this.colVector = null;
        }
    }

    private class IntervalYearMonthExtractor
    extends AbstractLongExtractor {
        private HiveIntervalYearMonth hiveIntervalYearMonth;

        IntervalYearMonthExtractor(int columnIndex) {
            super(columnIndex);
            this.object = PrimitiveObjectInspectorFactory.writableHiveIntervalYearMonthObjectInspector.create(new HiveIntervalYearMonth(0));
            this.hiveIntervalYearMonth = new HiveIntervalYearMonth(0);
        }

        @Override
        Object extract(int batchIndex) {
            int adjustedIndex;
            int n = adjustedIndex = this.colVector.isRepeating ? 0 : batchIndex;
            if (this.colVector.noNulls || !this.colVector.isNull[adjustedIndex]) {
                int totalMonths = (int)this.vector[adjustedIndex];
                this.hiveIntervalYearMonth.set(totalMonths);
                PrimitiveObjectInspectorFactory.writableHiveIntervalYearMonthObjectInspector.set(this.object, this.hiveIntervalYearMonth);
                return this.object;
            }
            return null;
        }
    }

    private class TimestampExtractor
    extends AbstractTimestampExtractor {
        protected Timestamp timestamp;

        TimestampExtractor(int columnIndex) {
            super(columnIndex);
            this.object = PrimitiveObjectInspectorFactory.writableTimestampObjectInspector.create(new Timestamp(0L));
            this.timestamp = new Timestamp(0L);
        }

        @Override
        Object extract(int batchIndex) {
            int adjustedIndex;
            int n = adjustedIndex = this.colVector.isRepeating ? 0 : batchIndex;
            if (this.colVector.noNulls || !this.colVector.isNull[adjustedIndex]) {
                this.colVector.timestampUpdate(this.timestamp, adjustedIndex);
                PrimitiveObjectInspectorFactory.writableTimestampObjectInspector.set(this.object, this.timestamp);
                return this.object;
            }
            return null;
        }
    }

    private abstract class AbstractTimestampExtractor
    extends Extractor {
        protected TimestampColumnVector colVector;

        AbstractTimestampExtractor(int columnIndex) {
            super(columnIndex);
        }

        @Override
        void setColumnVector(VectorizedRowBatch batch) {
            this.colVector = (TimestampColumnVector)batch.cols[this.columnIndex];
        }

        @Override
        void forgetColumnVector() {
            this.colVector = null;
        }
    }

    private class DateExtractor
    extends AbstractLongExtractor {
        private Date date;

        DateExtractor(int columnIndex) {
            super(columnIndex);
            this.object = PrimitiveObjectInspectorFactory.writableDateObjectInspector.create(new Date(0L));
            this.date = new Date(0L);
        }

        @Override
        Object extract(int batchIndex) {
            int adjustedIndex;
            int n = adjustedIndex = this.colVector.isRepeating ? 0 : batchIndex;
            if (this.colVector.noNulls || !this.colVector.isNull[adjustedIndex]) {
                long value = this.vector[adjustedIndex];
                this.date.setTime(DateWritable.daysToMillis((int)value));
                PrimitiveObjectInspectorFactory.writableDateObjectInspector.set(this.object, this.date);
                return this.object;
            }
            return null;
        }
    }

    private class LongExtractor
    extends AbstractLongExtractor {
        LongExtractor(int columnIndex) {
            super(columnIndex);
            this.object = PrimitiveObjectInspectorFactory.writableLongObjectInspector.create(0L);
        }

        @Override
        Object extract(int batchIndex) {
            int adjustedIndex;
            int n = adjustedIndex = this.colVector.isRepeating ? 0 : batchIndex;
            if (this.colVector.noNulls || !this.colVector.isNull[adjustedIndex]) {
                long value = this.vector[adjustedIndex];
                PrimitiveObjectInspectorFactory.writableLongObjectInspector.set(this.object, value);
                return this.object;
            }
            return null;
        }
    }

    private class IntExtractor
    extends AbstractLongExtractor {
        IntExtractor(int columnIndex) {
            super(columnIndex);
            this.object = PrimitiveObjectInspectorFactory.writableIntObjectInspector.create(0);
        }

        @Override
        Object extract(int batchIndex) {
            int adjustedIndex;
            int n = adjustedIndex = this.colVector.isRepeating ? 0 : batchIndex;
            if (this.colVector.noNulls || !this.colVector.isNull[adjustedIndex]) {
                long value = this.vector[adjustedIndex];
                PrimitiveObjectInspectorFactory.writableIntObjectInspector.set(this.object, (int)value);
                return this.object;
            }
            return null;
        }
    }

    private class ShortExtractor
    extends AbstractLongExtractor {
        ShortExtractor(int columnIndex) {
            super(columnIndex);
            this.object = PrimitiveObjectInspectorFactory.writableShortObjectInspector.create((short)0);
        }

        @Override
        Object extract(int batchIndex) {
            int adjustedIndex;
            int n = adjustedIndex = this.colVector.isRepeating ? 0 : batchIndex;
            if (this.colVector.noNulls || !this.colVector.isNull[adjustedIndex]) {
                long value = this.vector[adjustedIndex];
                PrimitiveObjectInspectorFactory.writableShortObjectInspector.set(this.object, (short)value);
                return this.object;
            }
            return null;
        }
    }

    protected class ByteExtractor
    extends AbstractLongExtractor {
        ByteExtractor(int columnIndex) {
            super(columnIndex);
            this.object = PrimitiveObjectInspectorFactory.writableByteObjectInspector.create((byte)0);
        }

        @Override
        Object extract(int batchIndex) {
            int adjustedIndex;
            int n = adjustedIndex = this.colVector.isRepeating ? 0 : batchIndex;
            if (this.colVector.noNulls || !this.colVector.isNull[adjustedIndex]) {
                long value = this.vector[adjustedIndex];
                PrimitiveObjectInspectorFactory.writableByteObjectInspector.set(this.object, (byte)value);
                return this.object;
            }
            return null;
        }
    }

    protected class BooleanExtractor
    extends AbstractLongExtractor {
        BooleanExtractor(int columnIndex) {
            super(columnIndex);
            this.object = PrimitiveObjectInspectorFactory.writableBooleanObjectInspector.create(false);
        }

        @Override
        Object extract(int batchIndex) {
            int adjustedIndex;
            int n = adjustedIndex = this.colVector.isRepeating ? 0 : batchIndex;
            if (this.colVector.noNulls || !this.colVector.isNull[adjustedIndex]) {
                long value = this.vector[adjustedIndex];
                PrimitiveObjectInspectorFactory.writableBooleanObjectInspector.set(this.object, value != 0L);
                return this.object;
            }
            return null;
        }
    }

    private abstract class AbstractLongExtractor
    extends Extractor {
        protected LongColumnVector colVector;
        protected long[] vector;

        AbstractLongExtractor(int columnIndex) {
            super(columnIndex);
        }

        @Override
        void setColumnVector(VectorizedRowBatch batch) {
            this.colVector = (LongColumnVector)batch.cols[this.columnIndex];
            this.vector = this.colVector.vector;
        }

        @Override
        void forgetColumnVector() {
            this.colVector = null;
            this.vector = null;
        }
    }

    private class VoidExtractor
    extends Extractor {
        VoidExtractor(int columnIndex) {
            super(columnIndex);
        }

        @Override
        void setColumnVector(VectorizedRowBatch batch) {
        }

        @Override
        void forgetColumnVector() {
        }

        @Override
        Object extract(int batchIndex) {
            return null;
        }
    }

    protected abstract class Extractor {
        protected int columnIndex;
        protected Object object;

        public Extractor(int columnIndex) {
            this.columnIndex = columnIndex;
        }

        public int getColumnIndex() {
            return this.columnIndex;
        }

        abstract void setColumnVector(VectorizedRowBatch var1);

        abstract void forgetColumnVector();

        abstract Object extract(int var1);
    }
}

