/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.orc;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DecimalColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.TimestampColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;

public class TypeDescription
implements Comparable<TypeDescription>,
Serializable {
    private static final int MAX_PRECISION = 38;
    private static final int MAX_SCALE = 38;
    private static final int DEFAULT_PRECISION = 38;
    private static final int DEFAULT_SCALE = 10;
    private static final int DEFAULT_LENGTH = 256;
    private int id = -1;
    private int maxId = -1;
    private TypeDescription parent;
    private final Category category;
    private final List<TypeDescription> children;
    private final List<String> fieldNames;
    private int maxLength = 256;
    private int precision = 38;
    private int scale = 10;

    @Override
    public int compareTo(TypeDescription other) {
        if (this == other) {
            return 0;
        }
        if (other == null) {
            return -1;
        }
        int result = this.category.compareTo(other.category);
        if (result == 0) {
            switch (this.category) {
                case CHAR: 
                case VARCHAR: {
                    return this.maxLength - other.maxLength;
                }
                case DECIMAL: {
                    if (this.precision != other.precision) {
                        return this.precision - other.precision;
                    }
                    return this.scale - other.scale;
                }
                case UNION: 
                case LIST: 
                case MAP: {
                    if (this.children.size() != other.children.size()) {
                        return this.children.size() - other.children.size();
                    }
                    for (int c = 0; result == 0 && c < this.children.size(); ++c) {
                        result = this.children.get(c).compareTo(other.children.get(c));
                    }
                    break;
                }
                case STRUCT: {
                    if (this.children.size() != other.children.size()) {
                        return this.children.size() - other.children.size();
                    }
                    for (int c = 0; result == 0 && c < this.children.size(); ++c) {
                        result = this.fieldNames.get(c).compareTo(other.fieldNames.get(c));
                        if (result != 0) continue;
                        result = this.children.get(c).compareTo(other.children.get(c));
                    }
                    break;
                }
            }
        }
        return result;
    }

    public static TypeDescription createBoolean() {
        return new TypeDescription(Category.BOOLEAN);
    }

    public static TypeDescription createByte() {
        return new TypeDescription(Category.BYTE);
    }

    public static TypeDescription createShort() {
        return new TypeDescription(Category.SHORT);
    }

    public static TypeDescription createInt() {
        return new TypeDescription(Category.INT);
    }

    public static TypeDescription createLong() {
        return new TypeDescription(Category.LONG);
    }

    public static TypeDescription createFloat() {
        return new TypeDescription(Category.FLOAT);
    }

    public static TypeDescription createDouble() {
        return new TypeDescription(Category.DOUBLE);
    }

    public static TypeDescription createString() {
        return new TypeDescription(Category.STRING);
    }

    public static TypeDescription createDate() {
        return new TypeDescription(Category.DATE);
    }

    public static TypeDescription createTimestamp() {
        return new TypeDescription(Category.TIMESTAMP);
    }

    public static TypeDescription createBinary() {
        return new TypeDescription(Category.BINARY);
    }

    public static TypeDescription createDecimal() {
        return new TypeDescription(Category.DECIMAL);
    }

    static Category parseCategory(StringPosition source) {
        char ch;
        int start = source.position;
        while (source.position < source.length && Character.isLetter(ch = source.value.charAt(source.position))) {
            ++source.position;
        }
        if (source.position != start) {
            String word = source.value.substring(start, source.position).toLowerCase();
            for (Category cat : Category.values()) {
                if (!cat.getName().equals(word)) continue;
                return cat;
            }
        }
        throw new IllegalArgumentException("Can't parse category at " + source);
    }

    static int parseInt(StringPosition source) {
        char ch;
        int start = source.position;
        int result = 0;
        while (source.position < source.length && Character.isDigit(ch = source.value.charAt(source.position))) {
            result = result * 10 + (ch - 48);
            ++source.position;
        }
        if (source.position == start) {
            throw new IllegalArgumentException("Missing integer at " + source);
        }
        return result;
    }

    static String parseName(StringPosition source) {
        char ch;
        int start = source.position;
        while (source.position < source.length && (Character.isLetterOrDigit(ch = source.value.charAt(source.position)) || ch == '.' || ch == '_')) {
            ++source.position;
        }
        if (source.position == start) {
            throw new IllegalArgumentException("Missing name at " + source);
        }
        return source.value.substring(start, source.position);
    }

    static void requireChar(StringPosition source, char required) {
        if (source.position >= source.length || source.value.charAt(source.position) != required) {
            throw new IllegalArgumentException("Missing required char '" + required + "' at " + source);
        }
        ++source.position;
    }

    static boolean consumeChar(StringPosition source, char ch) {
        boolean result;
        boolean bl = result = source.position < source.length && source.value.charAt(source.position) == ch;
        if (result) {
            ++source.position;
        }
        return result;
    }

    static void parseUnion(TypeDescription type, StringPosition source) {
        TypeDescription.requireChar(source, '<');
        do {
            type.addUnionChild(TypeDescription.parseType(source));
        } while (TypeDescription.consumeChar(source, ','));
        TypeDescription.requireChar(source, '>');
    }

    static void parseStruct(TypeDescription type, StringPosition source) {
        TypeDescription.requireChar(source, '<');
        do {
            String fieldName = TypeDescription.parseName(source);
            TypeDescription.requireChar(source, ':');
            type.addField(fieldName, TypeDescription.parseType(source));
        } while (TypeDescription.consumeChar(source, ','));
        TypeDescription.requireChar(source, '>');
    }

    static TypeDescription parseType(StringPosition source) {
        TypeDescription result = new TypeDescription(TypeDescription.parseCategory(source));
        switch (result.getCategory()) {
            case BINARY: 
            case BOOLEAN: 
            case BYTE: 
            case DATE: 
            case DOUBLE: 
            case FLOAT: 
            case INT: 
            case LONG: 
            case SHORT: 
            case STRING: 
            case TIMESTAMP: {
                break;
            }
            case CHAR: 
            case VARCHAR: {
                TypeDescription.requireChar(source, '(');
                result.withMaxLength(TypeDescription.parseInt(source));
                TypeDescription.requireChar(source, ')');
                break;
            }
            case DECIMAL: {
                TypeDescription.requireChar(source, '(');
                int precision = TypeDescription.parseInt(source);
                TypeDescription.requireChar(source, ',');
                result.withScale(TypeDescription.parseInt(source));
                result.withPrecision(precision);
                TypeDescription.requireChar(source, ')');
                break;
            }
            case LIST: {
                TypeDescription.requireChar(source, '<');
                result.children.add(TypeDescription.parseType(source));
                TypeDescription.requireChar(source, '>');
                break;
            }
            case MAP: {
                TypeDescription.requireChar(source, '<');
                result.children.add(TypeDescription.parseType(source));
                TypeDescription.requireChar(source, ',');
                result.children.add(TypeDescription.parseType(source));
                TypeDescription.requireChar(source, '>');
                break;
            }
            case UNION: {
                TypeDescription.parseUnion(result, source);
                break;
            }
            case STRUCT: {
                TypeDescription.parseStruct(result, source);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown type " + (Object)((Object)result.getCategory()) + " at " + source);
            }
        }
        return result;
    }

    public static TypeDescription fromString(String typeName) {
        if (typeName == null) {
            return null;
        }
        StringPosition source = new StringPosition(typeName);
        TypeDescription result = TypeDescription.parseType(source);
        if (source.position != source.length) {
            throw new IllegalArgumentException("Extra characters at " + source);
        }
        return result;
    }

    public TypeDescription withPrecision(int precision) {
        if (this.category != Category.DECIMAL) {
            throw new IllegalArgumentException("precision is only allowed on decimal and not " + this.category.name);
        }
        if (precision < 1 || precision > 38 || this.scale > precision) {
            throw new IllegalArgumentException("precision " + precision + " is out of range 1 .. " + this.scale);
        }
        this.precision = precision;
        return this;
    }

    public TypeDescription withScale(int scale) {
        if (this.category != Category.DECIMAL) {
            throw new IllegalArgumentException("scale is only allowed on decimal and not " + this.category.name);
        }
        if (scale < 0 || scale > 38 || scale > this.precision) {
            throw new IllegalArgumentException("scale is out of range at " + scale);
        }
        this.scale = scale;
        return this;
    }

    public static TypeDescription createVarchar() {
        return new TypeDescription(Category.VARCHAR);
    }

    public static TypeDescription createChar() {
        return new TypeDescription(Category.CHAR);
    }

    public TypeDescription withMaxLength(int maxLength) {
        if (this.category != Category.VARCHAR && this.category != Category.CHAR) {
            throw new IllegalArgumentException("maxLength is only allowed on char and varchar and not " + this.category.name);
        }
        this.maxLength = maxLength;
        return this;
    }

    public static TypeDescription createList(TypeDescription childType) {
        TypeDescription result = new TypeDescription(Category.LIST);
        result.children.add(childType);
        childType.parent = result;
        return result;
    }

    public static TypeDescription createMap(TypeDescription keyType, TypeDescription valueType) {
        TypeDescription result = new TypeDescription(Category.MAP);
        result.children.add(keyType);
        result.children.add(valueType);
        keyType.parent = result;
        valueType.parent = result;
        return result;
    }

    public static TypeDescription createUnion() {
        return new TypeDescription(Category.UNION);
    }

    public static TypeDescription createStruct() {
        return new TypeDescription(Category.STRUCT);
    }

    public TypeDescription addUnionChild(TypeDescription child) {
        if (this.category != Category.UNION) {
            throw new IllegalArgumentException("Can only add types to union type and not " + (Object)((Object)this.category));
        }
        this.children.add(child);
        child.parent = this;
        return this;
    }

    public TypeDescription addField(String field, TypeDescription fieldType) {
        if (this.category != Category.STRUCT) {
            throw new IllegalArgumentException("Can only add fields to struct type and not " + (Object)((Object)this.category));
        }
        this.fieldNames.add(field);
        this.children.add(fieldType);
        fieldType.parent = this;
        return this;
    }

    public int getId() {
        if (this.id == -1) {
            TypeDescription root = this;
            while (root.parent != null) {
                root = root.parent;
            }
            root.assignIds(0);
        }
        return this.id;
    }

    public TypeDescription clone() {
        TypeDescription result = new TypeDescription(this.category);
        result.maxLength = this.maxLength;
        result.precision = this.precision;
        result.scale = this.scale;
        if (this.fieldNames != null) {
            result.fieldNames.addAll(this.fieldNames);
        }
        if (this.children != null) {
            for (TypeDescription child : this.children) {
                TypeDescription clone = child.clone();
                clone.parent = result;
                result.children.add(clone);
            }
        }
        return result;
    }

    public int hashCode() {
        long result = this.category.ordinal() * 4241 + this.maxLength + this.precision * 13 + this.scale;
        if (this.children != null) {
            for (TypeDescription child : this.children) {
                result = result * 6959L + (long)child.hashCode();
            }
        }
        return (int)result;
    }

    public boolean equals(Object other) {
        int i;
        if (other == null || other.getClass() != this.getClass()) {
            return false;
        }
        if (other == this) {
            return true;
        }
        TypeDescription castOther = (TypeDescription)other;
        if (this.category != castOther.category || this.maxLength != castOther.maxLength || this.scale != castOther.scale || this.precision != castOther.precision) {
            return false;
        }
        if (this.children != null) {
            if (this.children.size() != castOther.children.size()) {
                return false;
            }
            for (i = 0; i < this.children.size(); ++i) {
                if (this.children.get(i).equals(castOther.children.get(i))) continue;
                return false;
            }
        }
        if (this.category == Category.STRUCT) {
            for (i = 0; i < this.fieldNames.size(); ++i) {
                if (this.fieldNames.get(i).equals(castOther.fieldNames.get(i))) continue;
                return false;
            }
        }
        return true;
    }

    public int getMaximumId() {
        if (this.maxId == -1) {
            TypeDescription root = this;
            while (root.parent != null) {
                root = root.parent;
            }
            root.assignIds(0);
        }
        return this.maxId;
    }

    private ColumnVector createColumn() {
        switch (this.category) {
            case BOOLEAN: 
            case BYTE: 
            case DATE: 
            case INT: 
            case LONG: 
            case SHORT: {
                return new LongColumnVector();
            }
            case TIMESTAMP: {
                return new TimestampColumnVector();
            }
            case DOUBLE: 
            case FLOAT: {
                return new DoubleColumnVector();
            }
            case DECIMAL: {
                return new DecimalColumnVector(this.precision, this.scale);
            }
            case CHAR: 
            case VARCHAR: 
            case BINARY: 
            case STRING: {
                return new BytesColumnVector();
            }
        }
        throw new IllegalArgumentException("Unknown type " + (Object)((Object)this.category));
    }

    public VectorizedRowBatch createRowBatch() {
        VectorizedRowBatch result;
        if (this.category == Category.STRUCT) {
            result = new VectorizedRowBatch(this.children.size(), 1024);
            for (int i = 0; i < result.cols.length; ++i) {
                result.cols[i] = this.children.get(i).createColumn();
            }
        } else {
            result = new VectorizedRowBatch(1, 1024);
            result.cols[0] = this.createColumn();
        }
        result.reset();
        return result;
    }

    public Category getCategory() {
        return this.category;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public int getPrecision() {
        return this.precision;
    }

    public int getScale() {
        return this.scale;
    }

    public List<String> getFieldNames() {
        return Collections.unmodifiableList(this.fieldNames);
    }

    public List<TypeDescription> getChildren() {
        return this.children == null ? null : Collections.unmodifiableList(this.children);
    }

    private int assignIds(int startId) {
        this.id = startId++;
        if (this.children != null) {
            for (TypeDescription child : this.children) {
                startId = child.assignIds(startId);
            }
        }
        this.maxId = startId - 1;
        return startId;
    }

    private TypeDescription(Category category) {
        this.category = category;
        this.children = category.isPrimitive ? null : new ArrayList<TypeDescription>();
        this.fieldNames = category == Category.STRUCT ? new ArrayList<String>() : null;
    }

    public void printToBuffer(StringBuilder buffer) {
        buffer.append(this.category.name);
        switch (this.category) {
            case DECIMAL: {
                buffer.append('(');
                buffer.append(this.precision);
                buffer.append(',');
                buffer.append(this.scale);
                buffer.append(')');
                break;
            }
            case CHAR: 
            case VARCHAR: {
                buffer.append('(');
                buffer.append(this.maxLength);
                buffer.append(')');
                break;
            }
            case UNION: 
            case LIST: 
            case MAP: {
                buffer.append('<');
                for (int i = 0; i < this.children.size(); ++i) {
                    if (i != 0) {
                        buffer.append(',');
                    }
                    this.children.get(i).printToBuffer(buffer);
                }
                buffer.append('>');
                break;
            }
            case STRUCT: {
                buffer.append('<');
                for (int i = 0; i < this.children.size(); ++i) {
                    if (i != 0) {
                        buffer.append(',');
                    }
                    buffer.append(this.fieldNames.get(i));
                    buffer.append(':');
                    this.children.get(i).printToBuffer(buffer);
                }
                buffer.append('>');
                break;
            }
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.printToBuffer(buffer);
        return buffer.toString();
    }

    private void printJsonToBuffer(String prefix, StringBuilder buffer, int indent) {
        int i;
        for (i = 0; i < indent; ++i) {
            buffer.append(' ');
        }
        buffer.append(prefix);
        buffer.append("{\"category\": \"");
        buffer.append(this.category.name);
        buffer.append("\", \"id\": ");
        buffer.append(this.getId());
        buffer.append(", \"max\": ");
        buffer.append(this.maxId);
        switch (this.category) {
            case DECIMAL: {
                buffer.append(", \"precision\": ");
                buffer.append(this.precision);
                buffer.append(", \"scale\": ");
                buffer.append(this.scale);
                break;
            }
            case CHAR: 
            case VARCHAR: {
                buffer.append(", \"length\": ");
                buffer.append(this.maxLength);
                break;
            }
            case UNION: 
            case LIST: 
            case MAP: {
                buffer.append(", \"children\": [");
                for (i = 0; i < this.children.size(); ++i) {
                    buffer.append('\n');
                    this.children.get(i).printJsonToBuffer("", buffer, indent + 2);
                    if (i == this.children.size() - 1) continue;
                    buffer.append(',');
                }
                buffer.append("]");
                break;
            }
            case STRUCT: {
                buffer.append(", \"fields\": [");
                for (i = 0; i < this.children.size(); ++i) {
                    buffer.append('\n');
                    this.children.get(i).printJsonToBuffer("\"" + this.fieldNames.get(i) + "\": ", buffer, indent + 2);
                    if (i == this.children.size() - 1) continue;
                    buffer.append(',');
                }
                buffer.append(']');
                break;
            }
        }
        buffer.append('}');
    }

    public String toJson() {
        StringBuilder buffer = new StringBuilder();
        this.printJsonToBuffer("", buffer, 0);
        return buffer.toString();
    }

    public TypeDescription findSubtype(int goal) {
        int id = this.getId();
        if (goal < id || goal > this.maxId) {
            throw new IllegalArgumentException("Unknown type id " + id + " in " + this.toJson());
        }
        if (goal == id) {
            return this;
        }
        TypeDescription prev = null;
        for (TypeDescription next : this.children) {
            if (next.id > goal) {
                return prev.findSubtype(goal);
            }
            prev = next;
        }
        return prev.findSubtype(goal);
    }

    static class StringPosition {
        final String value;
        int position;
        final int length;

        StringPosition(String value) {
            this.value = value;
            this.position = 0;
            this.length = value.length();
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder();
            buffer.append('\'');
            buffer.append(this.value.substring(0, this.position));
            buffer.append('^');
            buffer.append(this.value.substring(this.position));
            buffer.append('\'');
            return buffer.toString();
        }
    }

    public static enum Category {
        BOOLEAN("boolean", true),
        BYTE("tinyint", true),
        SHORT("smallint", true),
        INT("int", true),
        LONG("bigint", true),
        FLOAT("float", true),
        DOUBLE("double", true),
        STRING("string", true),
        DATE("date", true),
        TIMESTAMP("timestamp", true),
        BINARY("binary", true),
        DECIMAL("decimal", true),
        VARCHAR("varchar", true),
        CHAR("char", true),
        LIST("array", false),
        MAP("map", false),
        STRUCT("struct", false),
        UNION("uniontype", false);

        final boolean isPrimitive;
        final String name;

        private Category(String name, boolean isPrimitive) {
            this.name = name;
            this.isPrimitive = isPrimitive;
        }

        public boolean isPrimitive() {
            return this.isPrimitive;
        }

        public String getName() {
            return this.name;
        }
    }
}

