/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.parquet.convert;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.ql.io.parquet.convert.ConverterParent;
import org.apache.hadoop.hive.ql.io.parquet.convert.HiveGroupConverter;
import org.apache.hadoop.hive.ql.io.parquet.convert.Repeated;
import org.apache.hadoop.io.ArrayWritable;
import org.apache.hadoop.io.Writable;
import org.apache.parquet.io.api.Converter;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.Type;

public class HiveStructConverter
extends HiveGroupConverter {
    private final int totalFieldCount;
    private final Converter[] converters;
    private final ConverterParent parent;
    private final int index;
    private Writable[] writables;
    private final List<Repeated> repeatedConverters;
    private boolean reuseWritableArray = false;

    public HiveStructConverter(GroupType requestedSchema, GroupType tableSchema, Map<String, String> metadata) {
        this(requestedSchema, null, 0, tableSchema);
        this.setMetadata(metadata);
        this.reuseWritableArray = true;
        this.writables = new Writable[tableSchema.getFieldCount()];
    }

    public HiveStructConverter(GroupType groupType, ConverterParent parent, int index) {
        this(groupType, parent, index, groupType);
    }

    public HiveStructConverter(GroupType selectedGroupType, ConverterParent parent, int index, GroupType containingGroupType) {
        if (parent != null) {
            this.setMetadata(parent.getMetadata());
        }
        this.parent = parent;
        this.index = index;
        this.totalFieldCount = containingGroupType.getFieldCount();
        int selectedFieldCount = selectedGroupType.getFieldCount();
        this.converters = new Converter[selectedFieldCount];
        this.repeatedConverters = new ArrayList<Repeated>();
        List<Type> selectedFields = selectedGroupType.getFields();
        for (int i = 0; i < selectedFieldCount; ++i) {
            Type subtype = selectedFields.get(i);
            if (!containingGroupType.getFields().contains(subtype)) {
                throw new IllegalStateException("Group type [" + containingGroupType + "] does not contain requested field: " + subtype);
            }
            int fieldIndex = containingGroupType.getFieldIndex(subtype.getName());
            this.converters[i] = this.getFieldConverter(subtype, fieldIndex);
        }
    }

    private Converter getFieldConverter(Type type, int fieldIndex) {
        Converter converter;
        if (type.isRepetition(Type.Repetition.REPEATED)) {
            converter = type.isPrimitive() ? new Repeated.RepeatedPrimitiveConverter(type.asPrimitiveType(), this, fieldIndex) : new Repeated.RepeatedGroupConverter(type.asGroupType(), this, fieldIndex);
            this.repeatedConverters.add((Repeated)((Object)converter));
        } else {
            converter = HiveStructConverter.getConverterFromDescription(type, fieldIndex, (ConverterParent)this);
        }
        return converter;
    }

    public final ArrayWritable getCurrentArray() {
        return new ArrayWritable(Writable.class, this.writables);
    }

    @Override
    public void set(int fieldIndex, Writable value) {
        this.writables[fieldIndex] = value;
    }

    @Override
    public Converter getConverter(int fieldIndex) {
        return this.converters[fieldIndex];
    }

    @Override
    public void start() {
        if (this.reuseWritableArray) {
            for (int i = 0; i < this.writables.length; ++i) {
                this.writables[i] = null;
            }
        } else {
            this.writables = new Writable[this.totalFieldCount];
        }
        for (Repeated repeated : this.repeatedConverters) {
            repeated.parentStart();
        }
    }

    @Override
    public void end() {
        for (Repeated repeated : this.repeatedConverters) {
            repeated.parentEnd();
        }
        if (this.parent != null) {
            this.parent.set(this.index, (Writable)this.getCurrentArray());
        }
    }
}

