/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.correlation;

import java.util.HashSet;
import java.util.Set;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.plan.FileSinkDesc;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractCorrelationProcCtx
implements NodeProcessorCtx {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractCorrelationProcCtx.class);
    private ParseContext pctx;
    private final boolean trustScript;
    private final int minReducer;
    private final Set<Operator<?>> removedOps = new HashSet();

    public AbstractCorrelationProcCtx(ParseContext pctx) {
        this.trustScript = pctx.getConf().getBoolVar(HiveConf.ConfVars.HIVESCRIPTOPERATORTRUST);
        if (pctx.hasAcidWrite()) {
            StringBuilder tblNames = new StringBuilder();
            for (FileSinkDesc fsd : pctx.getAcidSinks()) {
                if (fsd.getTable() == null) continue;
                tblNames.append(fsd.getTable().getDbName()).append('.').append(fsd.getTable().getTableName()).append(',');
            }
            if (tblNames.length() > 0) {
                tblNames.setLength(tblNames.length() - 1);
            }
            LOG.info("Overriding " + (Object)((Object)HiveConf.ConfVars.HIVEOPTREDUCEDEDUPLICATIONMINREDUCER) + " to 1 due to a write to transactional table(s) " + tblNames);
            this.minReducer = 1;
        } else {
            this.minReducer = pctx.getConf().getIntVar(HiveConf.ConfVars.HIVEOPTREDUCEDEDUPLICATIONMINREDUCER);
        }
        this.pctx = pctx;
    }

    public ParseContext getPctx() {
        return this.pctx;
    }

    public void setPctx(ParseContext pctx) {
        this.pctx = pctx;
    }

    public boolean trustScript() {
        return this.trustScript;
    }

    public int minReducer() {
        return this.minReducer;
    }

    public boolean hasBeenRemoved(Operator<?> rsOp) {
        return this.removedOps.contains(rsOp);
    }

    public boolean addRemovedOperator(Operator<?> rsOp) {
        return this.removedOps.add(rsOp);
    }
}

