/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;

public class VectorPartitionDesc {
    private static long serialVersionUID = 1L;
    private final VectorMapOperatorReadType vectorMapOperatorReadType;
    boolean isInputFileFormatSelfDescribing;
    private TypeInfo[] dataTypeInfos;

    private VectorPartitionDesc(boolean isInputFileFormatSelfDescribing, VectorMapOperatorReadType vectorMapOperatorReadType) {
        this.vectorMapOperatorReadType = vectorMapOperatorReadType;
        this.isInputFileFormatSelfDescribing = isInputFileFormatSelfDescribing;
        this.dataTypeInfos = null;
    }

    public static VectorPartitionDesc createVectorizedInputFileFormat() {
        return new VectorPartitionDesc(true, VectorMapOperatorReadType.VECTORIZED_INPUT_FILE_FORMAT);
    }

    public VectorPartitionDesc clone() {
        VectorPartitionDesc result = new VectorPartitionDesc(this.isInputFileFormatSelfDescribing, this.vectorMapOperatorReadType);
        result.dataTypeInfos = Arrays.copyOf(this.dataTypeInfos, this.dataTypeInfos.length);
        return result;
    }

    public VectorMapOperatorReadType getVectorMapOperatorReadType() {
        return this.vectorMapOperatorReadType;
    }

    public boolean getIsInputFileFormatSelfDescribing() {
        return this.isInputFileFormatSelfDescribing;
    }

    public TypeInfo[] getDataTypeInfos() {
        return this.dataTypeInfos;
    }

    public void setDataTypeInfos(List<TypeInfo> dataTypeInfoList) {
        this.dataTypeInfos = dataTypeInfoList.toArray(new TypeInfo[0]);
    }

    public int getNonPartColumnCount() {
        return this.dataTypeInfos.length;
    }

    public static enum VectorMapOperatorReadType {
        NONE,
        VECTORIZED_INPUT_FILE_FORMAT;

    }
}

