/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.hadoop.mapreduce.converter.converters;

import org.apache.hadoop.io.BytesWritable;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.hadoop.mapreduce.converter.TypeConversionException;
import org.pentaho.hadoop.mapreduce.converter.TypeConverterFactory;
import org.pentaho.hadoop.mapreduce.converter.spi.ITypeConverter;

public class KettleTypeToBytesWritableConverter
implements ITypeConverter<Object, BytesWritable> {
    @Override
    public boolean canConvert(Class from, Class to) {
        return TypeConverterFactory.isKettleType(from) && BytesWritable.class.equals((Object)to);
    }

    @Override
    public BytesWritable convert(ValueMetaInterface meta, Object obj) throws TypeConversionException {
        try {
            BytesWritable result = new BytesWritable();
            byte[] binary = meta.getBinary(obj);
            result.set(binary, 0, binary.length);
            return result;
        }
        catch (Exception ex) {
            throw new TypeConversionException(BaseMessages.getString(TypeConverterFactory.class, (String)"ErrorConverting", (Object[])new Object[]{BytesWritable.class.getSimpleName(), obj}), ex);
        }
    }
}

