/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.schema.reader;

import org.exolab.castor.xml.AttributeSet;
import org.exolab.castor.xml.Namespaces;
import org.exolab.castor.xml.XMLException;
import org.exolab.castor.xml.schema.Annotation;
import org.exolab.castor.xml.schema.AttributeDecl;
import org.exolab.castor.xml.schema.AttributeGroupReference;
import org.exolab.castor.xml.schema.ComplexType;
import org.exolab.castor.xml.schema.ContentType;
import org.exolab.castor.xml.schema.ElementDecl;
import org.exolab.castor.xml.schema.Group;
import org.exolab.castor.xml.schema.ModelGroup;
import org.exolab.castor.xml.schema.Schema;
import org.exolab.castor.xml.schema.SchemaContext;
import org.exolab.castor.xml.schema.SchemaException;
import org.exolab.castor.xml.schema.SchemaNames;
import org.exolab.castor.xml.schema.Wildcard;
import org.exolab.castor.xml.schema.XMLType;
import org.exolab.castor.xml.schema.reader.AnnotationUnmarshaller;
import org.exolab.castor.xml.schema.reader.AttributeGroupUnmarshaller;
import org.exolab.castor.xml.schema.reader.AttributeUnmarshaller;
import org.exolab.castor.xml.schema.reader.ComplexContentUnmarshaller;
import org.exolab.castor.xml.schema.reader.ComponentReader;
import org.exolab.castor.xml.schema.reader.ElementUnmarshaller;
import org.exolab.castor.xml.schema.reader.GroupUnmarshaller;
import org.exolab.castor.xml.schema.reader.ModelGroupUnmarshaller;
import org.exolab.castor.xml.schema.reader.SimpleContentUnmarshaller;
import org.exolab.castor.xml.schema.reader.WildcardUnmarshaller;

public class ComplexTypeUnmarshaller
extends ComponentReader {
    private static final String VALUE_0 = "0";
    private static final String VALUE_1 = "1";
    private static final String VALUE_FALSE = "false";
    private static final String VALUE_TRUE = "true";
    private static final String KEYWORD_RESTRICTIONS = "restrictions";
    private static final String KEYWORD_EXTENSION = "extension";
    private static final String KEYWORD_DERIVED_BY = "derivedBy";
    private ComponentReader unmarshaller;
    private int depth = 0;
    private ComplexType _complexType = null;
    private boolean allowAnnotation = true;
    private boolean foundAnnotation = false;
    private boolean foundAnyAttribute = false;
    private boolean foundAttributes = false;
    private boolean foundSimpleContent = false;
    private boolean foundComplexContent = false;
    private boolean foundModelGroup = false;
    private Schema _schema = null;

    public ComplexTypeUnmarshaller(SchemaContext schemaContext, Schema schema, AttributeSet atts) throws XMLException {
        super(schemaContext);
        String base;
        this._schema = schema;
        this._complexType = schema.createComplexType();
        this._complexType.useResolver(this.getResolver());
        String attValue = null;
        this._complexType.setName(atts.getValue("name"));
        String content = atts.getValue("mixed");
        if (content != null) {
            if (this.isTurnedOn(content)) {
                this._complexType.setContentType(ContentType.mixed);
            }
            if (this.isTurnedOff(content)) {
                this._complexType.setContentType(ContentType.elemOnly);
            }
        }
        if ((base = atts.getValue("base")) != null && base.length() > 0) {
            String derivedBy = atts.getValue(KEYWORD_DERIVED_BY);
            this._complexType.setDerivationMethod(derivedBy);
            if (derivedBy == null || derivedBy.length() == 0 || derivedBy.equals(KEYWORD_EXTENSION)) {
                XMLType baseType = schema.getType(base);
                if (baseType == null) {
                    this._complexType.setBase(base);
                } else {
                    this._complexType.setBaseType(baseType);
                }
            } else {
                if (derivedBy.equals(KEYWORD_RESTRICTIONS)) {
                    String err = "restrictions not yet supported for <type>.";
                    throw new SchemaException(err);
                }
                String err = "invalid value for derivedBy attribute of ";
                err = err + "<type>: " + derivedBy;
                throw new SchemaException(err);
            }
        }
        if ((attValue = atts.getValue("abstract")) != null) {
            Boolean bool = Boolean.valueOf(attValue);
            this._complexType.setAbstract(bool);
        }
        this._complexType.setBlock(atts.getValue("block"));
        this._complexType.setFinal(atts.getValue("final"));
        this._complexType.setId(atts.getValue("id"));
    }

    private boolean isTurnedOff(String content) {
        return content.equals(VALUE_FALSE) || content.equals(VALUE_0);
    }

    private boolean isTurnedOn(String property) {
        return property.equals(VALUE_TRUE) || property.equals(VALUE_1);
    }

    @Override
    public String elementName() {
        return "complexType";
    }

    public ComplexType getComplexType() {
        return this._complexType;
    }

    @Override
    public Object getObject() {
        return this.getComplexType();
    }

    @Override
    public void startElement(String name, String namespace, AttributeSet atts, Namespaces nsDecls) throws XMLException {
        if (this.unmarshaller != null) {
            this.unmarshaller.startElement(name, namespace, atts, nsDecls);
            ++this.depth;
            return;
        }
        if ("anyAttribute".equals(name)) {
            if (this.foundComplexContent) {
                this.error("an anyAttribute element cannot appear as a child of 'complexType' if 'complexContent' also exists");
            }
            if (this.foundSimpleContent) {
                this.error("an anyAttribute element cannot appear as a child of 'complexType' if 'simpleContent' also exists");
            }
            this.foundAnyAttribute = true;
            this.allowAnnotation = true;
            this.unmarshaller = new WildcardUnmarshaller(this.getSchemaContext(), this._complexType, this._schema, name, atts);
        } else if ("attribute".equals(name)) {
            if (this.foundComplexContent) {
                this.error("an attribute definition cannot appear as a child of 'complexType' if 'complexContent' also exists");
            }
            if (this.foundSimpleContent) {
                this.error("an 'attribute' definition cannot appear as a child of 'complexType' if 'simpleContent' also exists");
            }
            if (this.foundAnyAttribute) {
                this.error("an attribute definition cannot appear after the definition of an 'anyAttribute' element");
            }
            this.foundAttributes = true;
            this.allowAnnotation = false;
            this.unmarshaller = new AttributeUnmarshaller(this.getSchemaContext(), this._schema, atts);
        } else if ("attributeGroup".equals(name)) {
            if (atts.getValue("ref") == null) {
                this.error("A 'complexType' may contain referring attributeGroups, but not defining ones.");
            }
            if (this.foundComplexContent) {
                this.error("an attributeGroup reference cannot appear as a child of 'complexType' if 'complexContent' also exists");
            }
            if (this.foundSimpleContent) {
                this.error("an attributeGroup reference cannot appear as a child of 'complexType' if 'simpleContent' also exists");
            }
            if (this.foundAnyAttribute) {
                this.error("an 'attributeGroup' reference cannot appear after the definition of an 'anyAttribute' element");
            }
            this.foundAttributes = true;
            this.allowAnnotation = false;
            this.unmarshaller = new AttributeGroupUnmarshaller(this.getSchemaContext(), this._schema, atts);
        } else if ("simpleContent".equals(name)) {
            if (this.foundAttributes) {
                this.error("'simpleContent' and attribute definitions cannot both appear as children of 'complexType' at the same time.");
            }
            if (this.foundComplexContent) {
                this.error("'simpleContent' and 'complexContent' cannot both appear as children of 'complexType'.");
            }
            if (this.foundSimpleContent) {
                this.error("Only one (1) 'simpleContent' may appear as a child of 'complexType'.");
            }
            if (this.foundModelGroup) {
                this.error("'simpleContent' cannot appear as a child of 'complexType' if 'all', 'sequence', 'choice' or 'group' also exist");
            }
            this.foundSimpleContent = true;
            this.allowAnnotation = false;
            this._complexType.setSimpleContent(true);
            this.unmarshaller = new SimpleContentUnmarshaller(this.getSchemaContext(), this._complexType, atts);
        } else if ("complexContent".equals(name)) {
            if (this.foundAttributes) {
                this.error("'complexContent' and attribute definitions cannot both appear as children of 'complexType' at the same time.");
            }
            if (this.foundSimpleContent) {
                this.error("'simpleContent' and 'complexContent' cannot both appear as children of 'complexType'.");
            }
            if (this.foundComplexContent) {
                this.error("Only one (1) 'complexContent' may appear as a child of 'complexType'.");
            }
            if (this.foundModelGroup) {
                this.error("'complexContent' cannot appear as a child of 'complexType' if 'all', 'sequence', 'choice' or 'group' also exist");
            }
            this.foundComplexContent = true;
            this.allowAnnotation = false;
            this._complexType.setComplexContent(true);
            this.unmarshaller = new ComplexContentUnmarshaller(this.getSchemaContext(), this._complexType, atts);
        } else if (name.equals("group")) {
            if (this.foundAttributes) {
                this.error("'" + name + "' must appear before any attribute " + "definitions when a child of 'complexType'.");
            }
            if (this.foundComplexContent) {
                this.error("'" + name + "' and 'complexContent' cannot both " + "appear as children of 'complexType'.");
            }
            if (this.foundSimpleContent) {
                this.error("'" + name + "' and 'simpleContent' cannot both " + "appear as children of 'complexType'.");
            }
            if (this.foundModelGroup) {
                this.error("'" + name + "' cannot appear as a child of 'complexType' " + "if another 'all', 'sequence', 'choice' or " + "'group' also exists.");
            }
            this.foundModelGroup = true;
            this.allowAnnotation = false;
            this.unmarshaller = new ModelGroupUnmarshaller(this.getSchemaContext(), this._schema, atts);
        } else if (SchemaNames.isGroupName(name) && name != "group") {
            if (this.foundAttributes) {
                this.error("'" + name + "' must appear before any attribute " + "definitions when a child of 'complexType'.");
            }
            if (this.foundComplexContent) {
                this.error("'" + name + "' and 'complexContent' cannot both " + "appear as children of 'complexType'.");
            }
            if (this.foundSimpleContent) {
                this.error("'" + name + "' and 'simpleContent' cannot both " + "appear as children of 'complexType'.");
            }
            if (this.foundModelGroup) {
                this.error("'" + name + "' cannot appear as a child of 'complexType' " + "if another 'all', 'sequence', 'choice' or " + "'group' also exists.");
            }
            this.foundModelGroup = true;
            this.allowAnnotation = false;
            this.unmarshaller = new GroupUnmarshaller(this.getSchemaContext(), this._schema, name, atts);
        } else if (name.equals("annotation")) {
            if (this.allowAnnotation) {
                this.unmarshaller = new AnnotationUnmarshaller(this.getSchemaContext(), atts);
                this.allowAnnotation = false;
                this.foundAnnotation = true;
            } else {
                if (this.foundAnnotation) {
                    this.error("Only one (1) annotation may appear as a child of 'complexType' elements");
                }
                this.error("An annotation must appear as the first child of 'complexType' elements.");
            }
        } else {
            this.illegalElement(name);
        }
    }

    @Override
    public void endElement(String name, String namespace) throws XMLException {
        Group group;
        if (this.unmarshaller != null && this.depth > 0) {
            this.unmarshaller.endElement(name, namespace);
            --this.depth;
            return;
        }
        this.unmarshaller.finish();
        if ("anyAttribute".equals(name)) {
            Wildcard wildcard = ((WildcardUnmarshaller)this.unmarshaller).getWildcard();
            try {
                this._complexType.setAnyAttribute(wildcard);
            }
            catch (SchemaException e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        }
        if ("attribute".equals(name)) {
            AttributeDecl attrDecl = ((AttributeUnmarshaller)this.unmarshaller).getAttribute();
            this._complexType.addAttributeDecl(attrDecl);
        } else if ("attributeGroup".equals(name)) {
            AttributeGroupReference attrGroupRef = (AttributeGroupReference)this.unmarshaller.getObject();
            this._complexType.addAttributeGroupReference(attrGroupRef);
        } else if ("element".equals(name)) {
            ElementDecl element = ((ElementUnmarshaller)this.unmarshaller).getElement();
            this._complexType.addElementDecl(element);
        } else if (name.equals("group")) {
            group = ((ModelGroupUnmarshaller)this.unmarshaller).getGroup();
            this._complexType.addGroup((ModelGroup)group);
        } else if (SchemaNames.isGroupName(name) && name != "group") {
            group = ((GroupUnmarshaller)this.unmarshaller).getGroup();
            this._complexType.addGroup(group);
        } else if ("annotation".equals(name)) {
            Annotation ann = ((AnnotationUnmarshaller)this.unmarshaller).getAnnotation();
            this._complexType.addAnnotation(ann);
        }
        this.unmarshaller = null;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws XMLException {
        if (this.unmarshaller != null) {
            this.unmarshaller.characters(ch, start, length);
        }
    }
}

