/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.schema.reader;

import org.exolab.castor.net.URIException;
import org.exolab.castor.net.URILocation;
import org.exolab.castor.net.URIResolver;
import org.exolab.castor.xml.AttributeSet;
import org.exolab.castor.xml.XMLException;
import org.exolab.castor.xml.schema.Schema;
import org.exolab.castor.xml.schema.SchemaContext;
import org.exolab.castor.xml.schema.SchemaException;
import org.exolab.castor.xml.schema.reader.ComponentReader;
import org.exolab.castor.xml.schema.reader.SchemaLocation;
import org.exolab.castor.xml.schema.reader.SchemaUnmarshaller;
import org.exolab.castor.xml.schema.reader.SchemaUnmarshallerState;
import org.xml.sax.Locator;
import org.xml.sax.Parser;

public class ImportUnmarshaller
extends ComponentReader {
    public ImportUnmarshaller(SchemaContext schemaContext, Schema schema, AttributeSet atts, URIResolver uriResolver, Locator locator, SchemaUnmarshallerState state) throws XMLException {
        super(schemaContext);
        boolean hasLocation;
        this.setURIResolver(uriResolver);
        URILocation uri = null;
        String schemaLocation = atts.getValue("schemaLocation");
        String namespace = atts.getValue("namespace");
        if (schemaLocation == null && namespace == null) {
            return;
        }
        boolean bl = hasLocation = schemaLocation != null;
        if (hasLocation) {
            if (schemaLocation.indexOf("\\") != -1) {
                String err = "'" + schemaLocation + "' is not a valid URI as defined by IETF RFC 2396.";
                err = err + "The URI mustn't contain '\\'.";
                throw new SchemaException(err);
            }
            if (namespace == null) {
                namespace = "";
            }
            if ((uri = this.derive(locator, schemaLocation)) != null) {
                schemaLocation = uri.getAbsoluteURI();
            }
        } else {
            schemaLocation = namespace;
            try {
                uri = this.getURIResolver().resolveURN(namespace);
            }
            catch (URIException urix) {
                throw new XMLException((Throwable)urix);
            }
            if (uri == null) {
                String err = "Unable to resolve Schema corresponding to namespace '" + namespace + "'.";
                throw new SchemaException(err);
            }
        }
        if (namespace.equals(schema.getTargetNamespace())) {
            throw new SchemaException("the 'namespace' attribute in the <import> element cannot be the same of the targetNamespace of the global schema");
        }
        boolean addSchema = false;
        Schema importedSchema = schema.getImportedSchema(namespace, true);
        if (state.processed(schemaLocation)) {
            if (importedSchema == null) {
                schema.addImportedSchema(state.getSchema(schemaLocation));
            }
            return;
        }
        boolean alreadyLoaded = false;
        if (importedSchema == null) {
            if (uri instanceof SchemaLocation) {
                importedSchema = ((SchemaLocation)uri).getSchema();
                schema.addImportedSchema(importedSchema);
                alreadyLoaded = true;
            } else {
                importedSchema = new Schema();
                addSchema = true;
            }
        } else if (hasLocation) {
            String tmpLocation = importedSchema.getSchemaLocation();
            boolean bl2 = alreadyLoaded = schemaLocation.equals(tmpLocation) || importedSchema.includeProcessed(schemaLocation);
            if (!alreadyLoaded) {
                importedSchema.addInclude(tmpLocation);
            }
        } else {
            alreadyLoaded = true;
        }
        state.markAsProcessed(schemaLocation, importedSchema);
        if (alreadyLoaded) {
            return;
        }
        Parser parser = this.createParser("import");
        SchemaUnmarshaller schemaUnmarshaller = new SchemaUnmarshaller(this.getSchemaContext(), state);
        schemaUnmarshaller.setURIResolver(this.getURIResolver());
        schemaUnmarshaller.setSchema(importedSchema);
        this.parseSchema(parser, schemaUnmarshaller, uri, schemaLocation, "import");
        if (addSchema) {
            importedSchema.setSchemaLocation(schemaLocation);
            schema.addImportedSchema(importedSchema);
        }
    }

    @Override
    public String elementName() {
        return "import";
    }

    @Override
    public Object getObject() {
        return null;
    }
}

