/*
 * Decompiled with CFR 0.152.
 */
package com.infobright.etl.model.datatype;

import com.infobright.etl.model.ValueConverter;
import com.infobright.etl.model.ValueConverterException;
import com.infobright.etl.model.datatype.AbstractColumnType;
import java.nio.ByteBuffer;

class TinyintType
extends AbstractColumnType {
    private byte data;

    TinyintType() {
    }

    public String getDataAsString() {
        return new Integer(this.data).toString();
    }

    public void getData(ByteBuffer byteBuffer) {
        byteBuffer.put(this.data);
    }

    public void setData(ByteBuffer byteBuffer) throws AbstractColumnType.InvalidDataException {
        this.data = byteBuffer.get();
    }

    public void setData(String string) {
        this.data = Byte.valueOf(string);
    }

    protected void zeroOutData() {
        this.data = 0;
    }

    public void setData(Object value, ValueConverter meta) throws ValueConverterException {
        if (value == null) {
            this.setIsNull(true);
        } else {
            Long val = meta.getInteger(value);
            if (val == null) {
                this.setIsNull(true);
            } else {
                this.setIsNull(false);
                if (val >= 128L || val < -128L) {
                    throw new ValueConverterException("Value " + val + " out of range for TINYINT");
                }
                this.data = val.byteValue();
            }
        }
    }

    public final boolean isNeedsEnclosures() {
        return false;
    }
}

