/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import javax.crypto.SecretKey;
import org.jgroups.annotations.MBean;
import org.jgroups.annotations.Property;
import org.jgroups.protocols.EncryptBase;
import org.jgroups.util.Util;

@MBean(description="Symmetric encryption protocol. The (shared) shared secret key is configured up front, e.g. via a key store, or injection")
public class SYM_ENCRYPT
extends EncryptBase {
    @Property(description="File on classpath that contains keystore repository")
    protected String keystore_name;
    @Property(description="The type of the keystore. Types are listed in http://docs.oracle.com/javase/8/docs/technotes/tools/unix/keytool.html")
    protected String keystore_type = "JCEKS";
    @Property(description="Password used to check the integrity/unlock the keystore. Change the default", exposeAsManagedAttribute=false)
    protected String store_password = "changeit";
    @Property(description="Password for recovering the key. Change the default", exposeAsManagedAttribute=false)
    protected String key_password;
    @Property(name="alias", description="Alias used for recovering the key. Change the default", exposeAsManagedAttribute=false)
    protected String alias = "mykey";

    public String keystoreName() {
        return this.keystore_name;
    }

    public SYM_ENCRYPT keystoreName(String n) {
        this.keystore_name = n;
        return this;
    }

    public String alias() {
        return this.alias;
    }

    public SYM_ENCRYPT alias(String a) {
        this.alias = a;
        return this;
    }

    public String storePassword() {
        return this.store_password;
    }

    public SYM_ENCRYPT storePassword(String pwd2) {
        this.store_password = pwd2;
        return this;
    }

    @Override
    public void init() throws Exception {
        if (this.key_password == null && this.store_password != null) {
            this.key_password = this.store_password;
            this.log.debug("%s: key_password used is same as store_password", this.local_addr);
        }
        this.readSecretKeyFromKeystore();
        super.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readSecretKeyFromKeystore() throws Exception {
        block11: {
            InputStream inputStream = null;
            KeyStore store = KeyStore.getInstance(this.keystore_type != null ? this.keystore_type : KeyStore.getDefaultType());
            SecretKey tempKey = null;
            try {
                if (this.secret_key != null) break block11;
                inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(this.keystore_name);
                if (inputStream == null) {
                    inputStream = new FileInputStream(this.keystore_name);
                }
                if (inputStream == null) {
                    throw new Exception("Unable to load keystore " + this.keystore_name + " ensure file is on classpath");
                }
                try {
                    store.load(inputStream, this.store_password.toCharArray());
                    tempKey = (SecretKey)store.getKey(this.alias, this.key_password.toCharArray());
                }
                catch (IOException e) {
                    throw new Exception("Unable to load keystore " + this.keystore_name + ": " + e);
                }
                catch (NoSuchAlgorithmException e) {
                    throw new Exception("No Such algorithm " + this.keystore_name + ": " + e);
                }
                catch (CertificateException e) {
                    throw new Exception("Certificate exception " + this.keystore_name + ": " + e);
                }
                if (tempKey == null) {
                    throw new Exception("Unable to retrieve key '" + this.alias + "' from keystore " + this.keystore_name);
                }
                this.secret_key = tempKey;
                if (this.sym_algorithm.equals("AES")) {
                    this.sym_algorithm = tempKey.getAlgorithm();
                }
            }
            finally {
                Util.close(inputStream);
            }
        }
    }
}

