/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v25.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v25.group.PPT_PCL_PATHWAY;
import ca.uhn.hl7v2.model.v25.group.PPT_PCL_PATIENT_VISIT;
import ca.uhn.hl7v2.model.v25.segment.PID;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.log.HapiLogFactory;

public class PPT_PCL_PATIENT
extends AbstractGroup {
    public PPT_PCL_PATIENT(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(PID.class, true, false);
            this.add(PPT_PCL_PATIENT_VISIT.class, false, false);
            this.add(PPT_PCL_PATHWAY.class, true, true);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error creating PPT_PCL_PATIENT - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.5";
    }

    public PID getPID() {
        PID ret = null;
        try {
            ret = (PID)this.get("PID");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public PPT_PCL_PATIENT_VISIT getPATIENT_VISIT() {
        PPT_PCL_PATIENT_VISIT ret = null;
        try {
            ret = (PPT_PCL_PATIENT_VISIT)this.get("PATIENT_VISIT");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public PPT_PCL_PATHWAY getPATHWAY() {
        PPT_PCL_PATHWAY ret = null;
        try {
            ret = (PPT_PCL_PATHWAY)this.get("PATHWAY");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public PPT_PCL_PATHWAY getPATHWAY(int rep) {
        PPT_PCL_PATHWAY ret = null;
        try {
            ret = (PPT_PCL_PATHWAY)this.get("PATHWAY", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getPATHWAYReps() {
        int reps = -1;
        try {
            reps = this.getAll("PATHWAY").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertPATHWAY(PPT_PCL_PATHWAY structure, int rep) throws HL7Exception {
        super.insertRepetition("PATHWAY", (Structure)structure, rep);
    }

    public PPT_PCL_PATHWAY insertPATHWAY(int rep) throws HL7Exception {
        return (PPT_PCL_PATHWAY)super.insertRepetition("PATHWAY", rep);
    }

    public PPT_PCL_PATHWAY removePATHWAY(int rep) throws HL7Exception {
        return (PPT_PCL_PATHWAY)super.removeRepetition("PATHWAY", rep);
    }
}

