/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.kettle.plugins.hdfs.vfs;

import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.pentaho.big.data.api.cluster.NamedCluster;
import org.pentaho.big.data.api.cluster.NamedClusterService;
import org.pentaho.big.data.kettle.plugins.hdfs.vfs.HadoopVfsConnection;
import org.pentaho.big.data.plugins.common.ui.NamedClusterWidgetImpl;
import org.pentaho.di.core.Props;
import org.pentaho.di.core.exception.KettleFileException;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.variables.Variables;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.runtime.test.RuntimeTester;
import org.pentaho.runtime.test.action.RuntimeTestActionService;
import org.pentaho.vfs.ui.CustomVfsUiPanel;
import org.pentaho.vfs.ui.VfsFileChooserDialog;

public class NamedClusterVfsFileChooserDialog
extends CustomVfsUiPanel {
    private static final Class<?> PKG = NamedClusterVfsFileChooserDialog.class;
    private LogChannel log = new LogChannel((Object)this);
    FileObject defaultInitialFile = null;
    FileObject hadoopRootFile = null;
    String hadoopOpenFromFolder = null;
    FileObject rootFile = null;
    FileObject initialFile = null;
    VfsFileChooserDialog vfsFileChooserDialog = null;
    String schemeName = "hc";
    private NamedClusterWidgetImpl namedClusterWidget = null;
    private String namedCluster = null;
    private final NamedClusterService namedClusterService;
    private final RuntimeTestActionService runtimeTestActionService;
    private final RuntimeTester runtimeTester;

    public NamedClusterVfsFileChooserDialog(String schemeName, String displayName, VfsFileChooserDialog vfsFileChooserDialog, FileObject rootFile, FileObject initialFile, NamedClusterService namedClusterService, RuntimeTestActionService runtimeTestActionService, RuntimeTester runtimeTester) {
        super(schemeName, displayName, vfsFileChooserDialog, 0);
        this.schemeName = schemeName;
        this.rootFile = rootFile;
        this.initialFile = initialFile;
        this.vfsFileChooserDialog = vfsFileChooserDialog;
        this.namedClusterService = namedClusterService;
        this.runtimeTestActionService = runtimeTestActionService;
        this.runtimeTester = runtimeTester;
        GridData gridData = new GridData(4, 0x1000000, true, false);
        this.setLayoutData(gridData);
        this.setLayout((Layout)new GridLayout(1, false));
        this.createConnectionPanel();
    }

    private void createConnectionPanel() {
        Group connectionGroup = new Group((Composite)this, 16);
        connectionGroup.setText(BaseMessages.getString(PKG, (String)"HadoopVfsFileChooserDialog.ConnectionGroup.Label", (String[])new String[0]));
        GridLayout connectionGroupLayout = new GridLayout();
        connectionGroupLayout.marginWidth = 5;
        connectionGroupLayout.marginHeight = 5;
        connectionGroupLayout.verticalSpacing = 5;
        connectionGroupLayout.horizontalSpacing = 5;
        GridData gData = new GridData(4, 4, true, false);
        connectionGroup.setLayoutData((Object)gData);
        connectionGroup.setLayout((Layout)connectionGroupLayout);
        this.setNamedClusterWidget(new NamedClusterWidgetImpl((Composite)connectionGroup, true, this.namedClusterService, this.runtimeTestActionService, this.runtimeTester));
        this.getNamedClusterWidget().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                try {
                    NamedClusterVfsFileChooserDialog.this.connect();
                }
                catch (Exception e) {
                    NamedClusterVfsFileChooserDialog.this.log.logDebug(e.getMessage());
                }
            }
        });
        Composite textFieldPanel = new Composite((Composite)connectionGroup, 0);
        GridData gridData = new GridData(4, 4, true, false);
        textFieldPanel.setLayoutData((Object)gridData);
        textFieldPanel.setLayout((Layout)new GridLayout(5, false));
    }

    public void initializeConnectionPanel(FileObject file) {
        this.initialFile = file;
    }

    private void showMessageAndLog(String title, String message, String messageToLog) {
        MessageBox box = new MessageBox(this.getShell());
        box.setText(title);
        box.setMessage(message);
        this.log.logError(messageToLog);
        box.open();
    }

    public VariableSpace getVariableSpace() {
        if (Spoon.getInstance().getActiveTransformation() != null) {
            return Spoon.getInstance().getActiveTransformation();
        }
        if (Spoon.getInstance().getActiveJob() != null) {
            return Spoon.getInstance().getActiveJob();
        }
        return new Variables();
    }

    public NamedClusterWidgetImpl getNamedClusterWidget() {
        return this.namedClusterWidget;
    }

    protected void setNamedClusterWidget(NamedClusterWidgetImpl namedClusterWidget) {
        this.namedClusterWidget = namedClusterWidget;
    }

    public void setNamedCluster(String namedCluster) {
        this.namedCluster = namedCluster;
    }

    public void activate() {
        this.vfsFileChooserDialog.setRootFile(null);
        this.vfsFileChooserDialog.setInitialFile(null);
        this.vfsFileChooserDialog.openFileCombo.setText("hc://");
        this.vfsFileChooserDialog.vfsBrowser.fileSystemTree.removeAll();
        this.getNamedClusterWidget().initiate();
        this.getNamedClusterWidget().setSelectedNamedCluster(this.namedCluster);
        super.activate();
    }

    public void connect() {
        NamedCluster nc = this.getNamedClusterWidget().getSelectedNamedCluster();
        HadoopVfsConnection hdfsConnection = new HadoopVfsConnection(nc, this.getVariableSpace());
        hdfsConnection.setCustomParameters(Props.getInstance());
        String connectionString = "hc://" + nc.getName();
        FileSystemOptions fsoptions = new FileSystemOptions();
        FileObject root = this.rootFile;
        try {
            root = KettleVFS.getFileObject((String)connectionString, (FileSystemOptions)fsoptions);
        }
        catch (KettleFileException exc) {
            this.showMessageAndLog(BaseMessages.getString(PKG, (String)"HadoopVfsFileChooserDialog.error", (String[])new String[0]), BaseMessages.getString(PKG, (String)"HadoopVfsFileChooserDialog.Connection.error", (String[])new String[0]), exc.getMessage());
        }
        this.vfsFileChooserDialog.setRootFile(root);
        this.vfsFileChooserDialog.setSelectedFile(root);
        this.rootFile = root;
    }

    public FileObject resolveFile(String fileUri) throws FileSystemException {
        try {
            return KettleVFS.getFileObject((String)fileUri, (VariableSpace)this.getVariableSpace(), (FileSystemOptions)this.getFileSystemOptions());
        }
        catch (KettleFileException e) {
            throw new FileSystemException((Throwable)e);
        }
    }

    public FileObject resolveFile(String fileUri, FileSystemOptions opts) throws FileSystemException {
        try {
            return KettleVFS.getFileObject((String)fileUri, (VariableSpace)this.getVariableSpace(), (FileSystemOptions)opts);
        }
        catch (KettleFileException e) {
            throw new FileSystemException((Throwable)e);
        }
    }

    protected FileSystemOptions getFileSystemOptions() throws FileSystemException {
        FileSystemOptions opts = new FileSystemOptions();
        return opts;
    }
}

