/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.osgi.platform.plugin.deployer.impl.handlers.pluginxml;

import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.pentaho.osgi.platform.plugin.deployer.api.PluginHandlingException;
import org.pentaho.osgi.platform.plugin.deployer.api.PluginMetadata;
import org.pentaho.osgi.platform.plugin.deployer.impl.JSONUtil;
import org.pentaho.osgi.platform.plugin.deployer.impl.handlers.PluginXmlFileHandler;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class PluginXmlExternalResourcesHandler
extends PluginXmlFileHandler {
    public static final String EXTERNAL_RESOURCES_FILE = "META-INF/js/externalResources.json";
    private JSONUtil jsonUtil;

    public PluginXmlExternalResourcesHandler() {
        super("//external-resources/file");
    }

    public void setJsonUtil(JSONUtil jsonUtil) {
        this.jsonUtil = jsonUtil;
    }

    @Override
    protected void handle(String relativePath, List<Node> nodes, PluginMetadata pluginMetadata) throws PluginHandlingException {
        if (nodes.size() > 0) {
            HashMap<String, List<String>> contextMap = new HashMap<String, List<String>>();
            for (Node node : nodes) {
                String contextFile;
                Map<String, String> attributes = this.getAttributes(node);
                String context = attributes.get("context");
                ArrayList<String> contextFiles = (ArrayList<String>)contextMap.get(context);
                if (contextFiles == null) {
                    contextFiles = new ArrayList<String>();
                    contextMap.put(context, contextFiles);
                }
                if (!(contextFile = node.getTextContent()).startsWith("/")) {
                    contextFile = "/" + contextFile;
                }
                contextFiles.add(contextFile);
            }
            FileWriter fileWriter = null;
            try {
                fileWriter = pluginMetadata.getFileWriter(EXTERNAL_RESOURCES_FILE);
                fileWriter.write(this.jsonUtil.prettyPrintMapStringListString(contextMap));
            }
            catch (IOException e) {
                throw new PluginHandlingException(e);
            }
            finally {
                if (fileWriter != null) {
                    try {
                        fileWriter.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            Document blueprint = pluginMetadata.getBlueprint();
            for (Map.Entry stringListEntry : contextMap.entrySet()) {
                for (String string : (List)stringListEntry.getValue()) {
                    Element service = blueprint.createElementNS("http://www.osgi.org/xmlns/blueprint/v1.0.0", "service");
                    service.setAttribute("interface", "org.pentaho.platform.api.engine.IPlatformWebResource");
                    Element bean = blueprint.createElementNS("http://www.osgi.org/xmlns/blueprint/v1.0.0", "bean");
                    bean.setAttribute("class", "org.pentaho.platform.pdi.PlatformWebResource");
                    Element argument = blueprint.createElementNS("http://www.osgi.org/xmlns/blueprint/v1.0.0", "argument");
                    argument.setAttribute("value", (String)stringListEntry.getKey());
                    bean.appendChild(argument);
                    argument = blueprint.createElementNS("http://www.osgi.org/xmlns/blueprint/v1.0.0", "argument");
                    argument.setAttribute("value", string);
                    bean.appendChild(argument);
                    service.appendChild(bean);
                    blueprint.getDocumentElement().appendChild(service);
                }
            }
        }
    }
}

