/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.stax.impl.algorithms;

import java.io.IOException;

public class DSAUtils {
    public static byte[] convertASN1toXMLDSIG(byte[] asn1Bytes) throws IOException {
        int sLength;
        int j;
        int rLength;
        int i;
        for (i = rLength = asn1Bytes[3]; i > 0 && asn1Bytes[4 + rLength - i] == 0; --i) {
        }
        for (j = sLength = asn1Bytes[5 + rLength]; j > 0 && asn1Bytes[6 + rLength + sLength - j] == 0; --j) {
        }
        if (asn1Bytes[0] != 48 || asn1Bytes[1] != asn1Bytes.length - 2 || asn1Bytes[2] != 2 || i > 20 || asn1Bytes[4 + rLength] != 2 || j > 20) {
            throw new IOException("Invalid ASN.1 format of DSA signature");
        }
        byte[] xmldsigBytes = new byte[40];
        System.arraycopy(asn1Bytes, 4 + rLength - i, xmldsigBytes, 20 - i, i);
        System.arraycopy(asn1Bytes, 6 + rLength + sLength - j, xmldsigBytes, 40 - j, j);
        return xmldsigBytes;
    }

    public static byte[] convertXMLDSIGtoASN1(byte[] xmldsigBytes) throws IOException {
        int k;
        int i;
        if (xmldsigBytes.length != 40) {
            throw new IOException("Invalid XMLDSIG format of DSA signature");
        }
        for (i = 20; i > 0 && xmldsigBytes[20 - i] == 0; --i) {
        }
        int j = i;
        if (xmldsigBytes[20 - i] < 0) {
            ++j;
        }
        for (k = 20; k > 0 && xmldsigBytes[40 - k] == 0; --k) {
        }
        int l = k;
        if (xmldsigBytes[40 - k] < 0) {
            ++l;
        }
        byte[] asn1Bytes = new byte[6 + j + l];
        asn1Bytes[0] = 48;
        asn1Bytes[1] = (byte)(4 + j + l);
        asn1Bytes[2] = 2;
        asn1Bytes[3] = (byte)j;
        System.arraycopy(xmldsigBytes, 20 - i, asn1Bytes, 4 + j - i, i);
        asn1Bytes[4 + j] = 2;
        asn1Bytes[5 + j] = (byte)l;
        System.arraycopy(xmldsigBytes, 40 - k, asn1Bytes, 6 + j + l - k, k);
        return asn1Bytes;
    }
}

