/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.base;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleSecurityException;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.plugins.RepositoryPluginType;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.metastore.MetaStoreConst;
import org.pentaho.di.repository.RepositoriesMeta;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositoryDirectoryInterface;
import org.pentaho.di.repository.RepositoryMeta;
import org.pentaho.di.repository.RepositoryOperation;
import org.pentaho.di.version.BuildVersion;
import org.pentaho.metastore.api.exceptions.MetaStoreException;
import org.pentaho.metastore.stores.delegate.DelegatingMetaStore;

public abstract class AbstractBaseCommandExecutor {
    private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SSS");
    public static final String YES = "Y";
    private LogChannelInterface log;
    private Class<?> pkgClazz;
    DelegatingMetaStore metaStore;
    private Result result = new Result();

    protected Result exitWithStatus(int exitStatus) {
        this.getResult().setExitStatus(exitStatus);
        return this.getResult();
    }

    public DelegatingMetaStore createDefaultMetastore() throws MetaStoreException {
        DelegatingMetaStore metaStore = new DelegatingMetaStore();
        metaStore.addMetaStore(MetaStoreConst.openLocalPentahoMetaStore());
        metaStore.setActiveMetaStoreName(metaStore.getName());
        return metaStore;
    }

    protected void logDebug(String messageKey) {
        if (this.getLog().isDebug()) {
            this.getLog().logDebug(BaseMessages.getString(this.getPkgClazz(), (String)messageKey, (String[])new String[0]));
        }
    }

    protected void logDebug(String messageKey, String ... messageTokens) {
        if (this.getLog().isDebug()) {
            this.getLog().logDebug(BaseMessages.getString(this.getPkgClazz(), (String)messageKey, (String[])messageTokens));
        }
    }

    protected int calculateAndPrintElapsedTime(Date start, Date stop, String startStopMsgTkn, String processingEndAfterMsgTkn, String processingEndAfterLongMsgTkn, String processingEndAfterLongerMsgTkn, String processingEndAfterLongestMsgTkn) {
        String begin = this.getDateFormat().format(start).toString();
        String end = this.getDateFormat().format(stop).toString();
        this.getLog().logMinimal(BaseMessages.getString(this.getPkgClazz(), (String)startStopMsgTkn, (String[])new String[]{begin, end}));
        long millis = stop.getTime() - start.getTime();
        int seconds = (int)(millis / 1000L);
        if (seconds <= 60) {
            this.getLog().logMinimal(BaseMessages.getString(this.getPkgClazz(), (String)processingEndAfterMsgTkn, (String[])new String[]{String.valueOf(seconds)}));
        } else if (seconds <= 3600) {
            int min = seconds / 60;
            int rem = seconds % 60;
            this.getLog().logMinimal(BaseMessages.getString(this.getPkgClazz(), (String)processingEndAfterLongMsgTkn, (String[])new String[]{String.valueOf(min), String.valueOf(rem), String.valueOf(seconds)}));
        } else if (seconds <= 86400) {
            int hour = seconds / 3600;
            int rem = seconds % 3600;
            int min = rem / 60;
            this.getLog().logMinimal(BaseMessages.getString(this.getPkgClazz(), (String)processingEndAfterLongerMsgTkn, (String[])new String[]{String.valueOf(hour), String.valueOf(min), String.valueOf(rem %= 60), String.valueOf(seconds)}));
        } else {
            int days = seconds / 86400;
            int rem = seconds % 86400;
            int hour = rem / 3600;
            int min = (rem %= 3600) / 60;
            this.getLog().logMinimal(BaseMessages.getString(this.getPkgClazz(), (String)processingEndAfterLongestMsgTkn, (String[])new String[]{String.valueOf(days), String.valueOf(hour), String.valueOf(min), String.valueOf(rem %= 60), String.valueOf(seconds)}));
        }
        return seconds;
    }

    protected void printVersion(String kettleVersionMsgTkn) {
        BuildVersion buildVersion = BuildVersion.getInstance();
        this.getLog().logBasic(BaseMessages.getString(this.getPkgClazz(), (String)kettleVersionMsgTkn, (String[])new String[]{buildVersion.getVersion(), buildVersion.getRevision(), buildVersion.getBuildDate()}));
    }

    public RepositoryMeta loadRepositoryConnection(String repoName, String loadingAvailableRepMsgTkn, String noRepsDefinedMsgTkn, String findingRepMsgTkn) throws KettleException {
        RepositoriesMeta repsinfo;
        if (Utils.isEmpty((CharSequence)repoName) || (repsinfo = this.loadRepositoryInfo(loadingAvailableRepMsgTkn, noRepsDefinedMsgTkn)) == null) {
            return null;
        }
        this.logDebug(findingRepMsgTkn, repoName);
        return repsinfo.findRepository(repoName);
    }

    public RepositoriesMeta loadRepositoryInfo(String loadingAvailableRepMsgTkn, String noRepsDefinedMsgTkn) throws KettleException {
        RepositoriesMeta repsinfo = new RepositoriesMeta();
        repsinfo.getLog().setLogLevel(this.getLog().getLogLevel());
        this.logDebug(loadingAvailableRepMsgTkn);
        try {
            repsinfo.readData();
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(this.getPkgClazz(), (String)noRepsDefinedMsgTkn, (String[])new String[0]), (Throwable)e);
        }
        return repsinfo;
    }

    public Repository establishRepositoryConnection(RepositoryMeta repositoryMeta, String username, String password, RepositoryOperation ... operations) throws KettleException, KettleSecurityException {
        Repository rep = (Repository)PluginRegistry.getInstance().loadClass(RepositoryPluginType.class, (Object)repositoryMeta, Repository.class);
        rep.init(repositoryMeta);
        rep.getLog().setLogLevel(this.getLog().getLogLevel());
        rep.connect(username != null ? username : null, password != null ? password : null);
        if (operations != null) {
            rep.getSecurityProvider().validateAction(operations);
        }
        return rep;
    }

    public void printRepositoryDirectories(Repository repository, RepositoryDirectoryInterface directory) throws KettleException {
        String[] directories = repository.getDirectoryNames(directory.getObjectId());
        if (directories != null) {
            for (String dir : directories) {
                System.out.println(dir);
            }
        }
    }

    protected void printParameter(String name, String value, String defaultValue, String description) {
        if (Utils.isEmpty((CharSequence)defaultValue)) {
            System.out.println("Parameter: " + name + "=" + Const.NVL((String)value, (String)"") + " : " + Const.NVL((String)description, (String)""));
        } else {
            System.out.println("Parameter: " + name + "=" + Const.NVL((String)value, (String)"") + ", default=" + defaultValue + " : " + Const.NVL((String)description, (String)""));
        }
    }

    public boolean isEnabled(String value) {
        return YES.equalsIgnoreCase(value) || Boolean.parseBoolean(value);
    }

    public LogChannelInterface getLog() {
        return this.log;
    }

    public void setLog(LogChannelInterface log) {
        this.log = log;
    }

    public Class<?> getPkgClazz() {
        return this.pkgClazz;
    }

    public void setPkgClazz(Class<?> pkgClazz) {
        this.pkgClazz = pkgClazz;
    }

    public DelegatingMetaStore getMetaStore() {
        return this.metaStore;
    }

    public void setMetaStore(DelegatingMetaStore metaStore) {
        this.metaStore = metaStore;
    }

    public SimpleDateFormat getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(SimpleDateFormat dateFormat) {
        this.dateFormat = dateFormat;
    }

    public Result getResult() {
        return this.result;
    }

    public void setResult(Result result) {
        this.result = result;
    }
}

