/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.logging;

import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.vfs2.FileObject;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LogChannelFileWriterBuffer;
import org.pentaho.di.core.logging.LoggingRegistry;
import org.pentaho.di.core.vfs.KettleVFS;

public class LogChannelFileWriter {
    private String logChannelId;
    private FileObject logFile;
    private boolean appending;
    private int pollingInterval;
    private AtomicBoolean active;
    private AtomicBoolean finished;
    private KettleException exception;
    protected OutputStream logFileOutputStream;
    private LogChannelFileWriterBuffer buffer;

    public LogChannelFileWriter(String logChannelId, FileObject logFile, boolean appending, int pollingInterval) throws KettleException {
        this.logChannelId = logChannelId;
        this.logFile = logFile;
        this.appending = appending;
        this.pollingInterval = pollingInterval;
        this.active = new AtomicBoolean(false);
        this.finished = new AtomicBoolean(false);
        try {
            this.logFileOutputStream = KettleVFS.getOutputStream((FileObject)logFile, (boolean)appending);
        }
        catch (IOException e) {
            throw new KettleException("There was an error while trying to open file '" + logFile + "' for writing", (Throwable)e);
        }
        this.buffer = new LogChannelFileWriterBuffer(this.logChannelId);
        LoggingRegistry.getInstance().registerLogChannelFileWriterBuffer(this.buffer);
    }

    public LogChannelFileWriter(String logChannelId, FileObject logFile, boolean appending) throws KettleException {
        this(logChannelId, logFile, appending, 1000);
    }

    public void startLogging() {
        this.exception = null;
        this.active.set(true);
        Thread thread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void run() {
                try {
                    while (LogChannelFileWriter.this.active.get() && LogChannelFileWriter.this.exception == null) {
                        LogChannelFileWriter.this.flush();
                        Thread.sleep(LogChannelFileWriter.this.pollingInterval);
                    }
                    LogChannelFileWriter.this.flush();
                    return;
                }
                catch (Exception e) {
                    LogChannelFileWriter.this.exception = new KettleException("There was an error logging to file '" + LogChannelFileWriter.this.logFile + "'", (Throwable)e);
                    return;
                }
                finally {
                    try {
                        if (LogChannelFileWriter.this.logFileOutputStream != null) {
                            LogChannelFileWriter.this.logFileOutputStream.close();
                            LogChannelFileWriter.this.logFileOutputStream = null;
                        }
                    }
                    catch (Exception e) {
                        LogChannelFileWriter.this.exception = new KettleException("There was an error closing log file file '" + LogChannelFileWriter.this.logFile + "'", (Throwable)e);
                    }
                    finally {
                        LogChannelFileWriter.this.finished.set(true);
                    }
                }
            }
        });
        thread.start();
    }

    public synchronized void flush() {
        try {
            StringBuffer buffer = this.buffer.getBuffer();
            this.logFileOutputStream.write(buffer.toString().getBytes());
            this.logFileOutputStream.flush();
        }
        catch (Exception e) {
            this.exception = new KettleException("There was an error logging to file '" + this.logFile + "'", (Throwable)e);
        }
    }

    public void stopLogging() {
        this.flush();
        this.active.set(false);
        while (!this.finished.get()) {
            Thread.yield();
        }
    }

    public KettleException getException() {
        return this.exception;
    }

    public String getLogChannelId() {
        return this.logChannelId;
    }

    public void setLogChannelId(String logChannelId) {
        this.logChannelId = logChannelId;
    }

    public FileObject getLogFile() {
        return this.logFile;
    }

    public void setLogFile(FileObject logFile) {
        this.logFile = logFile;
    }

    public boolean isAppending() {
        return this.appending;
    }

    public void setAppending(boolean appending) {
        this.appending = appending;
    }

    public int getPollingInterval() {
        return this.pollingInterval;
    }

    public void setPollingInterval(int pollingInterval) {
        this.pollingInterval = pollingInterval;
    }
}

