/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.repository.kdr;

import java.util.List;
import java.util.Map;
import org.json.simple.JSONObject;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.repository.BaseRepositoryMeta;
import org.pentaho.di.repository.RepositoriesMeta;
import org.pentaho.di.repository.RepositoryCapabilities;
import org.pentaho.di.repository.RepositoryMeta;
import org.w3c.dom.Node;

public class KettleDatabaseRepositoryMeta
extends BaseRepositoryMeta
implements RepositoryMeta {
    public static final String ID = "id";
    public static final String DATABASE_CONNECTION = "databaseConnection";
    public static String REPOSITORY_TYPE_ID = "KettleDatabaseRepository";
    private DatabaseMeta databaseMeta;

    public KettleDatabaseRepositoryMeta() {
        super(REPOSITORY_TYPE_ID);
    }

    public KettleDatabaseRepositoryMeta(String id, String name, String description, DatabaseMeta connection) {
        super(id, name, description);
        this.databaseMeta = connection;
    }

    public KettleDatabaseRepositoryMeta(String id) {
        super(id, "", "");
        this.databaseMeta = null;
    }

    @Override
    public RepositoryCapabilities getRepositoryCapabilities() {
        return new RepositoryCapabilities(){

            @Override
            public boolean supportsUsers() {
                return true;
            }

            @Override
            public boolean managesUsers() {
                return true;
            }

            @Override
            public boolean isReadOnly() {
                return false;
            }

            @Override
            public boolean supportsRevisions() {
                return false;
            }

            @Override
            public boolean supportsMetadata() {
                return true;
            }

            @Override
            public boolean supportsLocking() {
                return true;
            }

            @Override
            public boolean hasVersionRegistry() {
                return false;
            }

            @Override
            public boolean supportsAcls() {
                return false;
            }

            @Override
            public boolean supportsReferences() {
                return true;
            }
        };
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public Boolean isDefault() {
        return this.isDefault;
    }

    @Override
    public void setDefault(Boolean isDefault) {
        this.isDefault = isDefault;
    }

    public void setConnection(DatabaseMeta connection) {
        this.databaseMeta = connection;
    }

    public DatabaseMeta getConnection() {
        return this.databaseMeta;
    }

    @Override
    public String getXML() {
        StringBuilder retval = new StringBuilder(100);
        retval.append("  ").append(XMLHandler.openTag((String)"repository"));
        retval.append(super.getXML());
        retval.append("    ").append(XMLHandler.addTagValue((String)"connection", this.databaseMeta != null ? this.databaseMeta.getName() : null));
        retval.append("  ").append(XMLHandler.closeTag((String)"repository"));
        return retval.toString();
    }

    @Override
    public void loadXML(Node repnode, List<DatabaseMeta> databases) throws KettleException {
        super.loadXML(repnode, databases);
        try {
            String conn = XMLHandler.getTagValue((Node)repnode, (String)"connection");
            this.databaseMeta = DatabaseMeta.findDatabase(databases, (String)conn);
        }
        catch (Exception e) {
            throw new KettleException("Unable to load Kettle database repository meta object", (Throwable)e);
        }
    }

    @Override
    public RepositoryMeta clone() {
        return new KettleDatabaseRepositoryMeta(REPOSITORY_TYPE_ID, this.getName(), this.getDescription(), this.getConnection());
    }

    @Override
    public void populate(Map<String, Object> properties, RepositoriesMeta repositoriesMeta) {
        super.populate(properties, repositoriesMeta);
        String databaseConnection = (String)properties.get(DATABASE_CONNECTION);
        DatabaseMeta databaseMeta = repositoriesMeta.searchDatabase(databaseConnection);
        if (databaseMeta != null) {
            this.setConnection(databaseMeta);
        }
    }

    @Override
    public JSONObject toJSONObject() {
        JSONObject object = super.toJSONObject();
        object.put((Object)DATABASE_CONNECTION, (Object)(this.databaseMeta != null ? this.databaseMeta.getName() : ""));
        return object;
    }
}

