/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.cubeoutput;

import java.io.DataOutputStream;
import java.io.IOException;
import java.util.zip.GZIPOutputStream;
import org.pentaho.di.core.ResultFile;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleFileException;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.cubeoutput.CubeOutputData;
import org.pentaho.di.trans.steps.cubeoutput.CubeOutputMeta;

public class CubeOutput
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = CubeOutputMeta.class;
    private CubeOutputMeta meta;
    private CubeOutputData data;

    public CubeOutput(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    @Override
    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        this.meta = (CubeOutputMeta)smi;
        this.data = (CubeOutputData)sdi;
        boolean result = true;
        Object[] r = this.getRow();
        if (this.first) {
            this.data.outputMeta = this.getInputRowMeta() != null ? this.getInputRowMeta().clone() : this.getTransMeta().getPrevStepFields(this.getStepMeta());
            if (r == null && this.data.oneFileOpened && !(result = this.writeHeaderToFile())) {
                this.setErrors(1L);
                this.stopAll();
                return false;
            }
        }
        if (r == null) {
            this.setOutputDone();
            return false;
        }
        if (this.first) {
            if (this.meta.isDoNotOpenNewFileInit()) {
                try {
                    this.prepareFile();
                    this.data.oneFileOpened = true;
                }
                catch (KettleFileException ioe) {
                    this.logError(BaseMessages.getString(PKG, (String)"CubeOutput.Log.ErrorOpeningCubeOutputFile", (String[])new String[0]) + ioe.toString());
                    this.setErrors(1L);
                    return false;
                }
            }
            if (!(result = this.writeHeaderToFile())) {
                this.setErrors(1L);
                this.stopAll();
                return false;
            }
            this.first = false;
        }
        if (!(result = this.writeRowToFile(r))) {
            this.setErrors(1L);
            this.stopAll();
            return false;
        }
        this.putRow(this.data.outputMeta, r);
        if (this.checkFeedback(this.getLinesOutput()) && this.log.isBasic()) {
            this.logBasic(BaseMessages.getString(PKG, (String)"CubeOutput.Log.LineNumber", (String[])new String[0]) + this.getLinesOutput());
        }
        return result;
    }

    private synchronized boolean writeHeaderToFile() {
        try {
            this.data.outputMeta.writeMeta(this.data.dos);
        }
        catch (Exception e) {
            this.logError(BaseMessages.getString(PKG, (String)"CubeOutput.Log.ErrorWritingLine", (String[])new String[0]) + e.toString());
            return false;
        }
        return true;
    }

    private synchronized boolean writeRowToFile(Object[] r) {
        try {
            this.data.outputMeta.writeData(this.data.dos, r);
        }
        catch (Exception e) {
            this.logError(BaseMessages.getString(PKG, (String)"CubeOutput.Log.ErrorWritingLine", (String[])new String[0]) + e.toString());
            return false;
        }
        this.incrementLinesOutput();
        return true;
    }

    @Override
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (CubeOutputMeta)smi;
        this.data = (CubeOutputData)sdi;
        if (super.init(smi, sdi)) {
            if (!this.meta.isDoNotOpenNewFileInit()) {
                try {
                    this.prepareFile();
                    this.data.oneFileOpened = true;
                    return true;
                }
                catch (KettleFileException ioe) {
                    this.logError(BaseMessages.getString(PKG, (String)"CubeOutput.Log.ErrorOpeningCubeOutputFile", (String[])new String[0]) + ioe.toString());
                }
            } else {
                return true;
            }
        }
        return false;
    }

    private void prepareFile() throws KettleFileException {
        try {
            String filename = this.environmentSubstitute(this.meta.getFilename());
            if (this.meta.isAddToResultFiles()) {
                ResultFile resultFile = new ResultFile(0, KettleVFS.getFileObject((String)filename, (VariableSpace)this.getTransMeta()), this.getTransMeta().getName(), this.getStepname());
                resultFile.setComment("This file was created with a cube file output step");
                this.addResultFile(resultFile);
            }
            this.data.fos = KettleVFS.getOutputStream((String)filename, (VariableSpace)this.getTransMeta(), (boolean)false);
            this.data.zip = new GZIPOutputStream(this.data.fos);
            this.data.dos = new DataOutputStream(this.data.zip);
        }
        catch (Exception e) {
            throw new KettleFileException((Throwable)e);
        }
    }

    @Override
    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        if (this.data.oneFileOpened) {
            try {
                if (this.data.dos != null) {
                    this.data.dos.close();
                    this.data.dos = null;
                }
                if (this.data.zip != null) {
                    this.data.zip.close();
                    this.data.zip = null;
                }
                if (this.data.fos != null) {
                    this.data.fos.close();
                    this.data.fos = null;
                }
            }
            catch (IOException e) {
                this.logError(BaseMessages.getString(PKG, (String)"CubeOutput.Log.ErrorClosingFile", (String[])new String[0]) + this.meta.getFilename());
                this.setErrors(1L);
                this.stopAll();
            }
        }
        super.dispose(smi, sdi);
    }
}

