/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.bundle.command;

import java.util.ArrayList;
import java.util.List;
import org.apache.karaf.bundle.command.BundlesCommandWithConfirmation;
import org.apache.karaf.shell.commands.Command;
import org.apache.karaf.shell.console.MultiException;
import org.osgi.framework.Bundle;

@Command(scope="bundle", name="restart", description="Restarts bundles.")
public class Restart
extends BundlesCommandWithConfirmation {
    public Restart() {
        this.errorMessage = "Error restarting bundle";
    }

    @Override
    protected void doExecute(List<Bundle> bundles) throws Exception {
        if (bundles.isEmpty()) {
            System.err.println("No bundles specified.");
            return;
        }
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        for (Bundle bundle : bundles) {
            try {
                bundle.stop();
            }
            catch (Exception e) {
                exceptions.add(new Exception("Unable to stop bundle " + bundle.getBundleId() + ": " + e.getMessage(), e));
            }
        }
        for (Bundle bundle : bundles) {
            try {
                bundle.start();
            }
            catch (Exception e) {
                exceptions.add(new Exception("Unable to start bundle " + bundle.getBundleId() + ": " + e.getMessage(), e));
            }
        }
        MultiException.throwIf((String)"Error restarting bundles", exceptions);
    }

    @Override
    protected void executeOnBundle(Bundle bundle) throws Exception {
    }
}

