/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.core;

import java.util.List;
import org.apache.calcite.plan.Convention;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptSamplingParameters;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelInput;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.SingleRel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Sample
extends SingleRel {
    private final RelOptSamplingParameters params;

    public Sample(RelOptCluster cluster, RelNode child, RelOptSamplingParameters params) {
        super(cluster, cluster.traitSetOf(Convention.NONE), child);
        this.params = params;
    }

    public Sample(RelInput input) {
        this(input.getCluster(), input.getInput(), Sample.getSamplingParameters(input));
    }

    private static RelOptSamplingParameters getSamplingParameters(RelInput input) {
        String mode = input.getString("mode");
        float percentage = input.getFloat("rate");
        Object repeatableSeed = input.get("repeatableSeed");
        boolean repeatable = repeatableSeed instanceof Number;
        return new RelOptSamplingParameters(mode.equals("bernoulli"), percentage, repeatable, repeatable ? ((Number)repeatableSeed).intValue() : 0);
    }

    @Override
    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        assert (traitSet.containsIfApplicable(Convention.NONE));
        return new Sample(this.getCluster(), Sample.sole(inputs), this.params);
    }

    public RelOptSamplingParameters getSamplingParameters() {
        return this.params;
    }

    @Override
    public RelWriter explainTerms(RelWriter pw) {
        return super.explainTerms(pw).item("mode", this.params.isBernoulli() ? "bernoulli" : "system").item("rate", Float.valueOf(this.params.getSamplingPercentage())).item("repeatableSeed", this.params.isRepeatable() ? Integer.valueOf(this.params.getRepeatableSeed()) : "-");
    }
}

