/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.schema.impl;

import com.google.common.collect.ImmutableList;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.List;
import org.apache.calcite.adapter.enumerable.AggImplementor;
import org.apache.calcite.adapter.enumerable.RexImpTable;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.schema.AggregateFunction;
import org.apache.calcite.schema.FunctionParameter;
import org.apache.calcite.schema.ImplementableAggFunction;
import org.apache.calcite.schema.impl.ReflectiveFunctionBase;
import org.apache.calcite.util.Static;
import org.apache.calcite.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AggregateFunctionImpl
implements AggregateFunction,
ImplementableAggFunction {
    public final boolean isStatic;
    public final Method initMethod;
    public final Method addMethod;
    public final Method mergeMethod;
    public final Method resultMethod;
    public final ImmutableList<Class<?>> valueTypes;
    private final List<FunctionParameter> parameters;
    public final Class<?> accumulatorType;
    public final Class<?> resultType;
    public final Class<?> declaringClass;

    private AggregateFunctionImpl(Class<?> declaringClass, List<Class<?>> valueTypes, Class<?> accumulatorType, Class<?> resultType, Method initMethod, Method addMethod, Method mergeMethod, Method resultMethod) {
        this.declaringClass = declaringClass;
        this.isStatic = Modifier.isStatic(initMethod.getModifiers());
        this.valueTypes = ImmutableList.copyOf(valueTypes);
        this.parameters = ReflectiveFunctionBase.toFunctionParameters(valueTypes);
        this.accumulatorType = accumulatorType;
        this.resultType = resultType;
        this.initMethod = initMethod;
        this.addMethod = addMethod;
        this.mergeMethod = mergeMethod;
        this.resultMethod = resultMethod;
        assert (initMethod != null);
        assert (addMethod != null);
        assert (resultMethod != null || accumulatorType == resultType);
    }

    public static AggregateFunctionImpl create(Class<?> clazz) {
        Method initMethod = ReflectiveFunctionBase.findMethod(clazz, "init");
        Method addMethod = ReflectiveFunctionBase.findMethod(clazz, "add");
        Method mergeMethod = null;
        Method resultMethod = ReflectiveFunctionBase.findMethod(clazz, "result");
        if (initMethod != null && addMethod != null) {
            Class<?> accumulatorType = initMethod.getReturnType();
            Class<?> resultType = resultMethod != null ? resultMethod.getReturnType() : accumulatorType;
            ImmutableList addParamTypes = ImmutableList.copyOf((Object[])addMethod.getParameterTypes());
            if (addParamTypes.isEmpty() || addParamTypes.get(0) != accumulatorType) {
                throw Static.RESOURCE.firstParameterOfAdd(clazz.getName()).ex();
            }
            List<Class<?>> valueTypes = Util.skip(addParamTypes, 1);
            return new AggregateFunctionImpl(clazz, valueTypes, accumulatorType, resultType, initMethod, addMethod, mergeMethod, resultMethod);
        }
        return null;
    }

    @Override
    public List<FunctionParameter> getParameters() {
        return this.parameters;
    }

    @Override
    public RelDataType getReturnType(RelDataTypeFactory typeFactory) {
        return typeFactory.createJavaType(this.resultType);
    }

    @Override
    public AggImplementor getImplementor(boolean windowContext) {
        return new RexImpTable.UserDefinedAggReflectiveImplementor(this);
    }
}

