/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.amazon;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class InstanceType
implements Comparable<InstanceType> {
    private String type;
    private String instanceFamily;

    public InstanceType(String type, String instanceFamily) {
        this.type = type;
        this.instanceFamily = instanceFamily;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getInstanceFamily() {
        return this.instanceFamily;
    }

    public void setInstanceFamily(String instanceFamily) {
        this.instanceFamily = instanceFamily;
    }

    public static String createDescription(InstanceType type) {
        return type.getType() + " (" + type.getInstanceFamily() + ")";
    }

    public static String getTypeFromDescription(String description) {
        return description.trim().split("\\s+")[0];
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InstanceType instanceType = (InstanceType)o;
        return this.type != null ? this.type.equals(instanceType.type) : false;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    @Override
    public int compareTo(InstanceType instanceType) {
        return this.extractInt(this.type) - this.extractInt(instanceType.getType());
    }

    private int extractInt(String type) {
        String number = type.split("\\.")[1].replaceAll("\\D", "");
        return number.isEmpty() ? 0 : Integer.parseInt(number);
    }

    public static List<String> sortInstanceTypes(List<InstanceType> instances) {
        ArrayList<String> sortedInstances = new ArrayList<String>();
        Collections.sort(instances, (o1, o2) -> o1.getType().compareTo(o2.getType()));
        while (instances.size() > 0) {
            List instanceGroup = instances.stream().filter(e -> ((InstanceType)instances.get(0)).getType().split("\\.")[0].equals(e.getType().split("\\.")[0])).collect(Collectors.toList());
            instances.removeAll(instanceGroup);
            Collections.sort(instanceGroup);
            List instanceGroupTypes = instanceGroup.stream().map(e -> e.getType()).collect(Collectors.toList());
            sortedInstances.addAll(instanceGroupTypes);
        }
        return sortedInstances;
    }
}

