/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.hadoop.configuration;

import java.util.List;
import java.util.ResourceBundle;
import java.util.concurrent.atomic.AtomicReference;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.hadoop.HadoopConfigurationBootstrap;
import org.pentaho.di.core.hadoop.HadoopConfigurationInfo;
import org.pentaho.di.core.hadoop.HadoopConfigurationPrompter;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.ui.hadoop.configuration.HadoopConfigurationRestartXulDialog;
import org.pentaho.di.ui.hadoop.configuration.HadoopConfigurationsController;
import org.pentaho.di.ui.hadoop.configuration.HadoopConfigurationsXulDialog;
import org.pentaho.di.ui.hadoop.configuration.NoHadoopConfigurationsXulDialog;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.di.ui.spoon.SpoonLifecycleListener;
import org.pentaho.di.ui.spoon.SpoonPerspective;
import org.pentaho.di.ui.spoon.SpoonPlugin;
import org.pentaho.di.ui.spoon.SpoonPluginCategories;
import org.pentaho.di.ui.spoon.SpoonPluginInterface;
import org.pentaho.di.ui.spoon.XulSpoonResourceBundle;
import org.pentaho.ui.xul.XulDomContainer;
import org.pentaho.ui.xul.XulException;
import org.pentaho.ui.xul.impl.XulEventHandler;

@SpoonPluginCategories(value={"spoon"})
@SpoonPlugin(id="HadoopConfigurationsSpoonPlugin", image="")
public class HadoopConfigurationsSpoonPlugin
implements SpoonPluginInterface {
    private static Class<?> PKG = HadoopConfigurationsSpoonPlugin.class;
    private LogChannelInterface log = new LogChannel((Object)HadoopConfigurationsSpoonPlugin.class.getName());
    private ResourceBundle resourceBundle = new XulSpoonResourceBundle(PKG);

    public void applyToContainer(String category, XulDomContainer container) throws XulException {
        try {
            container.registerClassLoader((Object)this.getClass().getClassLoader());
            container.loadOverlay("org/pentaho/di/ui/hadoop/configuration/toolbar-overlay.xul", (Object)this.resourceBundle);
            HadoopConfigurationsController controller = new HadoopConfigurationsController();
            container.addEventHandler((XulEventHandler)controller);
        }
        catch (XulException e) {
            this.log.logError(e.getMessage());
        }
        HadoopConfigurationBootstrap.getInstance().setPrompter(new HadoopConfigurationPrompter(){

            @Override
            public String getConfigurationSelection(final List<HadoopConfigurationInfo> hadoopConfigurationInfos) {
                final Spoon spoon = Spoon.getInstance();
                final AtomicReference atomicReference = new AtomicReference();
                spoon.getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        atomicReference.set(Const.isEmpty((List)hadoopConfigurationInfos) ? new NoHadoopConfigurationsXulDialog(spoon.getShell()).open() : new HadoopConfigurationsXulDialog(spoon.getShell(), hadoopConfigurationInfos).open());
                    }
                });
                return (String)atomicReference.get();
            }

            @Override
            public void promptForRestart() {
                final Spoon spoon = Spoon.getInstance();
                spoon.getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        new HadoopConfigurationRestartXulDialog(spoon.getShell()).open();
                    }
                });
            }
        });
    }

    public SpoonLifecycleListener getLifecycleListener() {
        return null;
    }

    public SpoonPerspective getPerspective() {
        return null;
    }
}

