/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.hadoop.configuration;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Shell;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.hadoop.HadoopConfigurationInfo;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.ui.core.dialog.ShowHelpDialog;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.spoon.XulSpoonResourceBundle;
import org.pentaho.di.ui.spoon.XulSpoonSettingsManager;
import org.pentaho.di.ui.xul.KettleXulLoader;
import org.pentaho.ui.xul.XulDomContainer;
import org.pentaho.ui.xul.XulSettingsManager;
import org.pentaho.ui.xul.containers.XulDialog;
import org.pentaho.ui.xul.containers.XulListbox;
import org.pentaho.ui.xul.impl.AbstractXulEventHandler;
import org.pentaho.ui.xul.impl.XulEventHandler;
import org.pentaho.ui.xul.swt.SwtXulRunner;
import org.pentaho.ui.xul.swt.tags.SwtButton;
import org.pentaho.ui.xul.swt.tags.SwtDialog;

public class HadoopConfigurationsXulDialog
extends AbstractXulEventHandler {
    private static final Class<?> PKG = HadoopConfigurationsXulDialog.class;
    private static final String CONTROLLER_NAME = "hadoopConfigurationsXulDialog";
    private static final String XUL = "org/pentaho/di/ui/hadoop/configuration/select-config.xul";
    private static final Log logger = LogFactory.getLog(HadoopConfigurationsXulDialog.class);
    private final Shell shell;
    private final List<HadoopConfigurationInfo> hadoopConfigurationInfos;
    private XulDialog selectDialog;
    private boolean accept = false;

    public HadoopConfigurationsXulDialog(Shell aShell, List<HadoopConfigurationInfo> hadoopConfigurationInfos) {
        this.shell = new Shell(aShell, 66800);
        this.hadoopConfigurationInfos = new ArrayList<HadoopConfigurationInfo>(hadoopConfigurationInfos);
        Collections.sort(this.hadoopConfigurationInfos, new Comparator<HadoopConfigurationInfo>(){

            @Override
            public int compare(HadoopConfigurationInfo o1, HadoopConfigurationInfo o2) {
                int result = o1.getName().compareTo(o2.getName());
                if (result == 0) {
                    result = o1.getId().compareTo(o2.getId());
                }
                return result;
            }
        });
        this.setName(CONTROLLER_NAME);
    }

    public String open() {
        String selectedShim = "";
        try {
            KettleXulLoader e = new KettleXulLoader();
            e.setOuterContext((Object)this.shell);
            e.setIconsSize(24, 24);
            e.setSettingsManager((XulSettingsManager)XulSpoonSettingsManager.getInstance());
            e.registerClassLoader((Object)((Object)((Object)this)).getClass().getClassLoader());
            e.registerClassLoader((Object)KettleXulLoader.class.getClassLoader());
            XulDomContainer container = e.loadXul(XUL, (Object)new XulSpoonResourceBundle(PKG));
            container.addEventHandler((XulEventHandler)this);
            SwtXulRunner runner = new SwtXulRunner();
            runner.addContainer(container);
            runner.initialize();
            SwtButton helpButton = (SwtButton)container.getDocumentRoot().getElementById("helpButton");
            Button managedObject = (Button)helpButton.getManagedObject();
            managedObject.setImage(GUIResource.getInstance().getImageHelpWeb());
            this.selectDialog = (XulDialog)container.getDocumentRoot().getElementById("hadoopConfigurationSelectionDialog");
            XulListbox hadoopConfigurationSelectionDialogMenuListBox = (XulListbox)container.getDocumentRoot().getElementById("hadoopConfigurationSelectionDialogMenuListBox");
            int selectedIndex = -1;
            ArrayList<String> configs = new ArrayList<String>();
            boolean previousConfigHadSameName = false;
            for (int i = 0; i < this.hadoopConfigurationInfos.size(); ++i) {
                boolean nextConfigHasSameName;
                HadoopConfigurationInfo hadoopConfigurationInfo = this.hadoopConfigurationInfos.get(i);
                if (hadoopConfigurationInfo.isWillBeActiveAfterRestart()) {
                    selectedIndex = i;
                }
                boolean bl = nextConfigHasSameName = i < this.hadoopConfigurationInfos.size() - 1 && this.hadoopConfigurationInfos.get(i + 1).getName().equals(hadoopConfigurationInfo.getName());
                if (previousConfigHadSameName || nextConfigHasSameName) {
                    configs.add(hadoopConfigurationInfo.getName() + " (" + hadoopConfigurationInfo.getId() + ")");
                } else {
                    configs.add(hadoopConfigurationInfo.getName());
                }
                previousConfigHadSameName = nextConfigHasSameName;
            }
            hadoopConfigurationSelectionDialogMenuListBox.setElements(configs);
            if (selectedIndex >= 0) {
                hadoopConfigurationSelectionDialogMenuListBox.setSelectedIndex(selectedIndex);
            }
            hadoopConfigurationSelectionDialogMenuListBox.setRows(6);
            this.selectDialog.show();
            if (this.accept) {
                selectedShim = this.hadoopConfigurationInfos.get(hadoopConfigurationSelectionDialogMenuListBox.getSelectedIndex()).getId();
            }
            ((SwtDialog)this.selectDialog).dispose();
        }
        catch (Exception var4) {
            logger.info((Object)var4);
        }
        return selectedShim;
    }

    public void cancel() {
        this.selectDialog.hide();
    }

    public void accept() {
        this.accept = true;
        this.selectDialog.hide();
    }

    public void showHelp() {
        String docUrl = Const.getDocUrl((String)BaseMessages.getString(PKG, (String)"HadoopConfigurationSelectionDialog.Help.Url", (String[])new String[0]));
        ShowHelpDialog showHelpDialog = new ShowHelpDialog(this.shell, BaseMessages.getString(PKG, (String)"HadoopConfigurationSelectionDialog.Help.Title", (String[])new String[0]), docUrl, BaseMessages.getString(PKG, (String)"HadoopConfigurationSelectionDialog.Help.Header", (String[])new String[0])){

            protected Shell createShell(Shell parent) {
                return new Shell(parent, 66704);
            }
        };
        showHelpDialog.open();
        showHelpDialog.dispose();
    }
}

