/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.avatica.remote;

import java.sql.SQLException;
import org.apache.calcite.avatica.AvaticaConnection;
import org.apache.calcite.avatica.Meta;
import org.apache.calcite.avatica.MetaImpl;
import org.apache.calcite.avatica.remote.Service;

class RemoteMeta
extends MetaImpl {
    final Service service;

    public RemoteMeta(AvaticaConnection connection, Service service) {
        super(connection);
        this.service = service;
    }

    private Meta.MetaResultSet toResultSet(Service.ResultSetResponse response) {
        Meta.Signature signature0 = response.signature;
        return new Meta.MetaResultSet(response.statementId, response.ownStatement, signature0, response.rows);
    }

    public Meta.StatementHandle createStatement(Meta.ConnectionHandle ch) {
        Service.CreateStatementResponse response = this.service.apply(new Service.CreateStatementRequest(ch.id));
        return new Meta.StatementHandle(response.id);
    }

    public Meta.MetaResultSet getCatalogs() {
        Service.ResultSetResponse response = this.service.apply(new Service.CatalogsRequest());
        return this.toResultSet(response);
    }

    public Meta.MetaResultSet getSchemas(String catalog, Meta.Pat schemaPattern) {
        Service.ResultSetResponse response = this.service.apply(new Service.SchemasRequest(catalog, schemaPattern.s));
        return this.toResultSet(response);
    }

    public Meta.Signature prepare(Meta.StatementHandle h, String sql, int maxRowCount) {
        Service.PrepareResponse response = this.service.apply(new Service.PrepareRequest(h.id, sql, maxRowCount));
        return response.signature;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Meta.MetaResultSet prepareAndExecute(Meta.StatementHandle h, String sql, int maxRowCount, Meta.PrepareCallback callback) {
        try {
            Service.ResultSetResponse response;
            Object object = callback.getMonitor();
            synchronized (object) {
                callback.clear();
                response = this.service.apply(new Service.PrepareAndExecuteRequest(h.id, sql, maxRowCount));
                callback.assign(response.signature, response.rows);
            }
            callback.execute();
            return this.toResultSet(response);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }
}

