/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.amazon.hive.ui;

import java.lang.reflect.InvocationTargetException;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.eclipse.swt.widgets.Text;
import org.pentaho.amazon.AbstractAmazonJobEntry;
import org.pentaho.amazon.AbstractAmazonJobExecutorController;
import org.pentaho.amazon.hive.job.AmazonHiveJobExecutor;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.util.StringUtil;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.ui.core.database.dialog.tags.ExtTextbox;
import org.pentaho.ui.xul.XulDomContainer;
import org.pentaho.ui.xul.XulException;
import org.pentaho.ui.xul.binding.Binding;
import org.pentaho.ui.xul.binding.BindingConvertor;
import org.pentaho.ui.xul.binding.BindingFactory;

public class AmazonHiveJobExecutorController
extends AbstractAmazonJobExecutorController {
    private static final Class<?> PKG = AmazonHiveJobExecutor.class;
    public static final String Q_URL = "qUrl";
    public static final String BOOTSTRAP_ACTIONS = "bootstrapActions";
    public static final String XUL_QURL = "q-url";
    public static final String XUL_BOOTSTRAP_ACTIONS = "bootstrap-actions";
    private String qUrl = "";
    private String bootstrapActions = "";
    private AmazonHiveJobExecutor jobEntry;

    public AmazonHiveJobExecutorController(XulDomContainer container, AbstractAmazonJobEntry jobEntry, BindingFactory bindingFactory) {
        super(container, jobEntry, bindingFactory);
        this.jobEntry = (AmazonHiveJobExecutor)jobEntry;
        this.initializeEmrSettingsGroupMenuFields();
    }

    @Override
    protected void initializeTextFields() {
        super.initializeTextFields();
        ExtTextbox tempBox = (ExtTextbox)this.container.getDocumentRoot().getElementById(XUL_QURL);
        tempBox.setVariableSpace(this.getVariableSpace());
        tempBox = (ExtTextbox)this.container.getDocumentRoot().getElementById(XUL_BOOTSTRAP_ACTIONS);
        tempBox.setVariableSpace(this.getVariableSpace());
    }

    @Override
    protected void createBindings() {
        super.createBindings();
        this.bindingFactory.setBindingType(Binding.Type.BI_DIRECTIONAL);
        this.bindingFactory.createBinding(XUL_BOOTSTRAP_ACTIONS, "value", (Object)this, BOOTSTRAP_ACTIONS, new BindingConvertor[0]);
        this.bindingFactory.createBinding(XUL_QURL, "value", (Object)this, Q_URL, new BindingConvertor[0]);
        this.initializeTextFields();
    }

    @Override
    public String getDialogElementId() {
        return "amazon-emr-job-entry-dialog";
    }

    @Override
    protected void syncModel() {
        super.syncModel();
        ExtTextbox tempBox = (ExtTextbox)this.getXulDomContainer().getDocumentRoot().getElementById(XUL_BOOTSTRAP_ACTIONS);
        this.bootstrapActions = ((Text)tempBox.getTextControl()).getText();
        tempBox = (ExtTextbox)this.getXulDomContainer().getDocumentRoot().getElementById(XUL_QURL);
        this.qUrl = ((Text)tempBox.getTextControl()).getText();
    }

    @Override
    protected String buildValidationErrorMessages() {
        String validationErrors = super.buildValidationErrorMessages();
        if (StringUtil.isEmpty((String)this.qUrl)) {
            validationErrors = validationErrors + BaseMessages.getString(PKG, (String)"AmazonHiveJobExecutor.QURL.Error", (String[])new String[0]) + "\n";
        }
        return validationErrors;
    }

    @Override
    protected void configureJobEntry() {
        super.configureJobEntry();
        this.jobEntry.setQUrl(this.qUrl);
        this.jobEntry.setBootstrapActions(this.bootstrapActions);
    }

    @Override
    public void init() throws XulException, InvocationTargetException {
        this.createBindings();
        super.init();
        if (this.jobEntry != null) {
            this.setQUrl(this.jobEntry.getQUrl());
            this.setBootstrapActions(this.jobEntry.getBootstrapActions());
        }
    }

    public void browseQ() throws KettleException, FileSystemException {
        String[] fileFilters = new String[]{"*.*"};
        String[] fileFilterNames = new String[]{"All"};
        FileSystemOptions opts = this.getFileSystemOptions();
        FileObject selectedFile = this.browse(fileFilters, fileFilterNames, this.getVariableSpace().environmentSubstitute(this.qUrl), opts, 0, true);
        if (selectedFile != null) {
            this.setQUrl(selectedFile.getName().getURI());
        }
    }

    public String getQUrl() {
        return this.qUrl;
    }

    public void setQUrl(String qUrl) {
        String previousVal = this.qUrl;
        String newVal = qUrl;
        this.qUrl = qUrl;
        this.firePropertyChange(Q_URL, previousVal, newVal);
    }

    public String getBootstrapActions() {
        return this.bootstrapActions;
    }

    public void setBootstrapActions(String bootstrapActions) {
        String previousVal = this.bootstrapActions;
        String newVal = bootstrapActions;
        this.bootstrapActions = bootstrapActions;
        this.firePropertyChange(BOOTSTRAP_ACTIONS, previousVal, newVal);
    }

    @Override
    public void invertAlive() {
        this.setAlive(!this.isAlive());
    }

    @Override
    public void invertBlocking() {
        this.setBlocking(!this.getBlocking());
    }

    @Override
    public AbstractAmazonJobEntry getJobEntry() {
        return this.jobEntry;
    }

    @Override
    public void setJobEntry(AbstractAmazonJobEntry jobEntry) {
        this.jobEntry = (AmazonHiveJobExecutor)jobEntry;
    }
}

