/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.core.namedcluster;

import java.util.ArrayList;
import java.util.List;
import org.pentaho.di.core.namedcluster.NamedClusterManager;
import org.pentaho.di.core.namedcluster.model.NamedCluster;
import org.pentaho.di.ui.core.namedcluster.NamedClusterUIFactory;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.metastore.api.IMetaStore;
import org.pentaho.metastore.api.exceptions.MetaStoreException;

public class NamedClusterUIHelper {
    private static final NamedClusterUIFactoryHolder NAMED_CLUSTER_UI_FACTORY_HOLDER = new NamedClusterUIFactoryHolder();

    public static synchronized NamedClusterUIFactory getNamedClusterUIFactory() {
        return NAMED_CLUSTER_UI_FACTORY_HOLDER.getNamedClusterUIFactory();
    }

    public static void setNamedClusterUIFactory(NamedClusterUIFactory namedClusterUIFactory) {
        NAMED_CLUSTER_UI_FACTORY_HOLDER.setNamedClusterUIFactory(namedClusterUIFactory);
    }

    public static List<NamedCluster> getNamedClusters() {
        try {
            return NamedClusterManager.getInstance().list((IMetaStore)Spoon.getInstance().getMetaStore());
        }
        catch (MetaStoreException e) {
            return new ArrayList<NamedCluster>();
        }
    }

    public static NamedCluster getNamedCluster(String namedCluster) throws MetaStoreException {
        return NamedClusterManager.getInstance().read(namedCluster, (IMetaStore)Spoon.getInstance().getMetaStore());
    }

    static class NamedClusterUIFactoryHolder {
        private NamedClusterUIFactory namedClusterUIFactory;

        NamedClusterUIFactoryHolder() {
        }

        public synchronized NamedClusterUIFactory getNamedClusterUIFactory() {
            while (this.namedClusterUIFactory == null) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            return this.namedClusterUIFactory;
        }

        public synchronized void setNamedClusterUIFactory(NamedClusterUIFactory namedClusterUIFactory) {
            this.namedClusterUIFactory = namedClusterUIFactory;
            this.notifyAll();
        }
    }
}

