/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.logging.log4j;

import java.io.File;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.xml.DOMConfigurator;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.logging.KettleLogStore;
import org.pentaho.di.core.logging.KettleLoggingEvent;
import org.pentaho.di.core.logging.KettleLoggingEventListener;
import org.pentaho.di.core.logging.LoggingPlugin;
import org.pentaho.di.core.logging.LoggingPluginInterface;

@LoggingPlugin(id="Log4jLogging", isSeparateClassLoaderNeeded=true)
public class Log4jLogging
implements LoggingPluginInterface {
    public static final String PLUGIN_PROPERTIES_FILE = "plugins" + File.separator + "kettle5-log4j-plugin" + File.separator + "log4j.xml";
    public static final String STRING_PENTAHO_DI_LOGGER_NAME = "org.pentaho.di";
    public static final String STRING_PENTAHO_DI_CONSOLE_APPENDER = "ConsoleAppender:org.pentaho.di";
    private Logger pentahoLogger;

    public void eventAdded(KettleLoggingEvent event) {
        switch (event.getLevel()) {
            case ERROR: {
                this.pentahoLogger.log((Priority)Level.ERROR, event.getMessage());
                break;
            }
            case DEBUG: 
            case ROWLEVEL: {
                this.pentahoLogger.log((Priority)Level.DEBUG, event.getMessage());
                break;
            }
            default: {
                this.pentahoLogger.log((Priority)Level.INFO, event.getMessage());
            }
        }
    }

    public void init() {
        this.pentahoLogger = this.createLogger(STRING_PENTAHO_DI_LOGGER_NAME);
        this.pentahoLogger.setAdditivity(false);
        KettleLogStore.getAppender().addLoggingEventListener((KettleLoggingEventListener)this);
    }

    public void dispose() {
        KettleLogStore.getAppender().removeLoggingEventListener((KettleLoggingEventListener)this);
    }

    private void applyLog4jConfiguration() {
        LogLog.setQuietMode((boolean)true);
        LogManager.resetConfiguration();
        LogLog.setQuietMode((boolean)false);
        String log4jPath = this.getPluginPath().startsWith(this.getKettleDirPath()) ? Const.getKettleDirectory() + File.separator + PLUGIN_PROPERTIES_FILE : this.getConfigurationFileName();
        DOMConfigurator.configure((String)log4jPath);
    }

    Logger createLogger(String loggerName) {
        this.applyLog4jConfiguration();
        return Logger.getLogger((String)loggerName);
    }

    String getConfigurationFileName() {
        return PLUGIN_PROPERTIES_FILE;
    }

    private String getPluginPath() {
        return new File(this.getClass().getProtectionDomain().getCodeSource().getLocation().getPath()).getPath();
    }

    private String getKettleDirPath() {
        return new File(Const.getKettleDirectory()).getPath();
    }
}

