/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.pentaho.reporting.engine.classic.core.ReportEnvironment;

public class CachingReportEnvironment
implements ReportEnvironment {
    private static final Object NULLOBJECT = new Object();
    private ReportEnvironment backend;
    private Locale locale;
    private TimeZone timeZone;
    private String urlEncoding;
    private HashMap<String, Object> properties;

    public CachingReportEnvironment(ReportEnvironment backend) {
        this.backend = backend;
        this.properties = new HashMap();
    }

    @Override
    public Object getEnvironmentProperty(String key) {
        Object fromCache = this.properties.get(key);
        if (fromCache != null) {
            if (fromCache != NULLOBJECT) {
                return fromCache;
            }
            return null;
        }
        Object fromBackend = this.backend.getEnvironmentProperty(key);
        if (fromBackend == null) {
            this.properties.put(key, NULLOBJECT);
        } else {
            this.properties.put(key, fromBackend);
        }
        return fromBackend;
    }

    @Override
    public String getURLEncoding() {
        if (this.urlEncoding == null) {
            this.urlEncoding = this.backend.getURLEncoding();
        }
        return this.urlEncoding;
    }

    @Override
    public Locale getLocale() {
        if (this.locale == null) {
            this.locale = this.backend.getLocale();
        }
        return this.locale;
    }

    @Override
    public TimeZone getTimeZone() {
        if (this.timeZone == null) {
            this.timeZone = this.backend.getTimeZone();
        }
        return this.timeZone;
    }

    @Override
    public Map<String, String[]> getUrlExtraParameter() {
        return this.backend.getUrlExtraParameter();
    }

    @Override
    public Object clone() {
        return this;
    }
}

