/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.cache;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;

public class DataCacheKey {
    public static final String QUERY_CACHE = "QueryCache";
    private Map<String, Object> parameter = new HashMap<String, Object>();
    private Map<String, Object> attributes = new HashMap<String, Object>();

    public void addParameter(String key, Object value) {
        if (key == null) {
            throw new NullPointerException();
        }
        this.parameter.put(key, value);
    }

    public void addAttribute(String key, Object value) {
        if (key == null) {
            throw new NullPointerException();
        }
        this.attributes.put(key, value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataCacheKey that = (DataCacheKey)o;
        if (!this.equalsMap(this.attributes, that.attributes)) {
            return false;
        }
        return this.equalsMap(this.parameter, that.parameter);
    }

    public int hashCode() {
        int result = this.hashCodeMap(this.parameter);
        result = 31 * result + this.hashCodeMap(this.attributes);
        return result;
    }

    public void makeReadOnly() {
        this.parameter = DataCacheKey.toImmutable(this.parameter);
        this.attributes = DataCacheKey.toImmutable(this.attributes);
    }

    private static Map<String, Object> toImmutable(Map<String, Object> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<String, Object> entry = map.entrySet().iterator().next();
                return Collections.singletonMap(entry.getKey(), entry.getValue());
            }
        }
        return Collections.unmodifiableMap(map);
    }

    private boolean equalsMap(Map<String, Object> values, Map<String, Object> otherValues) {
        if (otherValues.size() != values.size()) {
            return false;
        }
        for (String key : values.keySet()) {
            Object value = values.get(key);
            Object otherValue = otherValues.get(key);
            if (value == null && otherValue == null || !(value instanceof Object[] && otherValue instanceof Object[] ? !ObjectUtilities.equalArray((Object[])((Object[])value), (Object[])((Object[])otherValue)) : !ObjectUtilities.equal((Object)value, (Object)otherValue))) continue;
            return false;
        }
        return true;
    }

    private int hashCodeMap(Map<String, Object> values) {
        int hashCode = values.size();
        for (String key : values.keySet()) {
            Object value = values.get(key);
            hashCode = 31 * hashCode + (key != null ? key.hashCode() : 0);
            if (value == null) {
                hashCode = 31 * hashCode;
                continue;
            }
            if (value instanceof Object[]) {
                hashCode = 31 * hashCode + ObjectUtilities.hashCode((Object[])((Object[])value));
                continue;
            }
            hashCode = 31 * hashCode + value.hashCode();
        }
        return hashCode;
    }
}

