/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.function;

import org.pentaho.reporting.engine.classic.core.DataRow;
import org.pentaho.reporting.engine.classic.core.ResourceBundleFactory;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.function.ExpressionRuntime;
import org.pentaho.reporting.libraries.base.config.Configuration;

public abstract class AbstractExpression
implements Expression {
    private String name;
    private int dependency;
    private transient ExpressionRuntime runtime;
    private boolean preserve;

    protected AbstractExpression() {
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public final boolean isActive() {
        return true;
    }

    public final void setActive(boolean active) {
    }

    @Override
    public int getDependencyLevel() {
        return this.dependency;
    }

    @Override
    public void setDependencyLevel(int level) {
        if (level < 0) {
            throw new IllegalArgumentException("AbstractExpression.setDependencyLevel(...) : negative dependency not allowed for user-defined expressions.");
        }
        this.dependency = level;
    }

    @Override
    public DataRow getDataRow() {
        if (this.runtime == null) {
            throw new IllegalStateException("Runtime is null");
        }
        return this.runtime.getDataRow();
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    @Override
    public Expression getInstance() {
        try {
            AbstractExpression abstractExpression = (AbstractExpression)this.clone();
            abstractExpression.setRuntime(null);
            return abstractExpression;
        }
        catch (CloneNotSupportedException cne) {
            throw new IllegalStateException("Clone must always be supported.");
        }
    }

    @Override
    public ResourceBundleFactory getResourceBundleFactory() {
        if (this.runtime == null) {
            throw new IllegalStateException("Runtime is null");
        }
        return this.runtime.getResourceBundleFactory();
    }

    @Override
    public Configuration getReportConfiguration() {
        if (this.runtime == null) {
            throw new IllegalStateException("Runtime is null");
        }
        return this.runtime.getConfiguration();
    }

    @Override
    public void setRuntime(ExpressionRuntime runtime) {
        this.runtime = runtime;
    }

    @Override
    public ExpressionRuntime getRuntime() {
        return this.runtime;
    }

    @Override
    public boolean isDeepTraversing() {
        return false;
    }

    @Override
    public boolean isPreserve() {
        return this.preserve;
    }

    public void setPreserve(boolean preserve) {
        this.preserve = preserve;
    }
}

