/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.function;

import java.util.HashMap;
import org.pentaho.reporting.engine.classic.core.event.ReportEvent;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.function.FunctionUtilities;
import org.pentaho.reporting.engine.classic.core.function.PageFunction;
import org.pentaho.reporting.engine.classic.core.states.ReportStateKey;

public class PageTotalFunction
extends PageFunction {
    private HashMap groupPages = new HashMap();
    private transient ReportStateKey currentStateKey;
    private boolean firstGroupSeen;

    public PageTotalFunction() {
        this.setDependencyLevel(0);
    }

    @Override
    public void reportInitialized(ReportEvent event) {
        super.reportInitialized(event);
        if (event.isDeepTraversing()) {
            return;
        }
        this.firstGroupSeen = false;
        this.currentStateKey = event.getState().getProcessKey();
    }

    @Override
    public void groupStarted(ReportEvent event) {
        super.groupStarted(event);
        if (event.isDeepTraversing()) {
            return;
        }
        if (this.getGroup() == null) {
            return;
        }
        if (FunctionUtilities.isDefinedGroup(this.getGroup(), event)) {
            if (!this.firstGroupSeen) {
                this.firstGroupSeen = true;
                return;
            }
            this.currentStateKey = event.getState().getProcessKey();
        }
    }

    @Override
    public void groupFinished(ReportEvent event) {
        super.groupFinished(event);
        if (event.isDeepTraversing()) {
            return;
        }
        if (this.getGroup() == null) {
            return;
        }
        if (FunctionUtilities.isDefinedGroup(this.getGroup(), event) && event.getState().isPrepareRun()) {
            this.groupPages.put(this.currentStateKey, super.getValue());
        }
    }

    @Override
    public void pageFinished(ReportEvent event) {
        if (event.getState().isPrepareRun()) {
            this.groupPages.put(this.currentStateKey, super.getValue());
        }
    }

    @Override
    public void reportDone(ReportEvent event) {
        if (event.isDeepTraversing()) {
            return;
        }
        if (event.getState().isPrepareRun()) {
            this.groupPages.put(this.currentStateKey, super.getValue());
        }
    }

    @Override
    public Expression getInstance() {
        PageTotalFunction function = (PageTotalFunction)super.getInstance();
        function.groupPages = new HashMap();
        return function;
    }

    @Override
    public Object getValue() {
        return this.groupPages.get(this.currentStateKey);
    }
}

