/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.function;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.HashMap;
import org.pentaho.reporting.engine.classic.core.event.ReportEvent;
import org.pentaho.reporting.engine.classic.core.function.AbstractFunction;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.function.FunctionUtilities;
import org.pentaho.reporting.engine.classic.core.states.ReportStateKey;
import org.pentaho.reporting.engine.classic.core.util.Sequence;

public class TotalCalculationFunction
extends AbstractFunction {
    private transient HashMap<ReportStateKey, Sequence<Object>> results = new HashMap();
    private transient int lastGroupSequenceNumber;
    private String field;
    private String group;
    private Sequence<Object> result;
    private transient ReportStateKey globalStateKey;
    private String crosstabFilterGroup;

    @Override
    public void reportInitialized(ReportEvent event) {
        this.globalStateKey = event.getState().getProcessKey();
        if (FunctionUtilities.isDefinedPrepareRunLevel(this, event)) {
            this.result = new Sequence();
            this.results.clear();
            this.results.put(this.globalStateKey, this.result);
            this.lastGroupSequenceNumber = 0;
        } else {
            this.result = this.results.get(this.globalStateKey);
            this.lastGroupSequenceNumber = 0;
        }
    }

    @Override
    public void groupStarted(ReportEvent event) {
        if (FunctionUtilities.isDefinedGroup(this.getGroup(), event)) {
            ReportStateKey groupStateKey = event.getState().getProcessKey();
            if (FunctionUtilities.isDefinedPrepareRunLevel(this, event)) {
                this.result = new Sequence();
                this.lastGroupSequenceNumber = 0;
                this.results.put(this.globalStateKey, this.result);
                this.results.put(groupStateKey, this.result);
            } else {
                this.result = this.results.get(groupStateKey);
            }
        }
        if (FunctionUtilities.isDefinedGroup(this.getCrosstabFilterGroup(), event)) {
            int groupIndex = event.getState().getCurrentGroupIndex();
            this.lastGroupSequenceNumber = (int)event.getState().getCrosstabColumnSequenceCounter(groupIndex);
        }
    }

    @Override
    public void itemsAdvanced(ReportEvent event) {
        if (this.field == null) {
            return;
        }
        if (!FunctionUtilities.isDefinedPrepareRunLevel(this, event)) {
            return;
        }
        Object value = event.getDataRow().get(this.getField());
        this.result.set(this.lastGroupSequenceNumber, value);
    }

    @Override
    public void summaryRowSelection(ReportEvent event) {
        if (FunctionUtilities.isDefinedGroup(this.getCrosstabFilterGroup(), event)) {
            int groupIndex = event.getState().getCurrentGroupIndex();
            this.lastGroupSequenceNumber = (int)event.getState().getCrosstabColumnSequenceCounter(groupIndex);
        }
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public String getField() {
        return this.field;
    }

    public void setField(String field) {
        this.field = field;
    }

    @Override
    public Object getValue() {
        if (this.result == null) {
            return null;
        }
        return this.result.get(this.lastGroupSequenceNumber);
    }

    public String getCrosstabFilterGroup() {
        return this.crosstabFilterGroup;
    }

    public void setCrosstabFilterGroup(String crosstabFilterGroup) {
        this.crosstabFilterGroup = crosstabFilterGroup;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.results = new HashMap();
    }

    @Override
    public Expression getInstance() {
        TotalCalculationFunction fn = (TotalCalculationFunction)super.getInstance();
        fn.results = new HashMap();
        return fn;
    }
}

