/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.output;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.event.ReportProgressEvent;
import org.pentaho.reporting.engine.classic.core.event.ReportProgressListener;
import org.pentaho.reporting.libraries.base.util.MemoryUsageMessage;
import org.pentaho.reporting.libraries.formatting.FastMessageFormat;

public class PerformanceProgressLogger
implements ReportProgressListener {
    private static final Log logger = LogFactory.getLog(PerformanceProgressLogger.class);
    private static final int ROW_PROGRESS = 5000;
    private int lastPage;
    private int lastRow;
    private int lastStage;
    private int lastActivity;
    private long startTime;
    private int rowCount;
    private boolean logPageProgress;
    private boolean logLevelProgress;
    private boolean logRowProgress;

    public PerformanceProgressLogger() {
        this(true, true, true);
    }

    public PerformanceProgressLogger(boolean logLevelProgress, boolean logPageProgress, boolean logRowProgress) {
        this.logLevelProgress = logLevelProgress;
        this.logPageProgress = logPageProgress;
        this.logRowProgress = logRowProgress;
    }

    @Override
    public void reportProcessingStarted(ReportProgressEvent event) {
        if (!logger.isInfoEnabled()) {
            return;
        }
        this.rowCount = -1;
        this.startTime = System.currentTimeMillis();
        logger.info((Object)new MemoryUsageMessage("[" + Thread.currentThread().getName() + "] Report Processing started. "));
    }

    @Override
    public void reportProcessingUpdate(ReportProgressEvent event) {
        int modRow;
        if (!logger.isInfoEnabled()) {
            return;
        }
        this.rowCount = event.getMaximumRow();
        boolean print = false;
        if (this.lastStage != event.getLevel() || this.lastActivity != event.getActivity()) {
            this.lastStage = event.getLevel();
            this.lastActivity = event.getActivity();
            this.lastRow = 0;
            if (this.logLevelProgress) {
                print = true;
            }
        }
        if (this.lastPage != event.getPage()) {
            this.lastPage = event.getPage();
            if (this.logPageProgress) {
                print = true;
            }
        }
        if ((modRow = event.getRow() - this.lastRow) > 5000) {
            this.lastRow = event.getRow() / 5000 * 5000;
            if (this.logRowProgress) {
                print = true;
            }
        }
        if (print) {
            logger.info((Object)new MemoryUsageMessage("[" + Thread.currentThread().getName() + "] Activity: " + event.getActivity() + " Level: " + this.lastStage + " Processing page: " + this.lastPage + " Row: " + this.lastRow + " Time: " + (System.currentTimeMillis() - this.startTime) + "ms "));
        }
    }

    @Override
    public void reportProcessingFinished(ReportProgressEvent event) {
        if (!logger.isInfoEnabled()) {
            return;
        }
        FastMessageFormat messageFormat = new FastMessageFormat("[{0}] Report Processing Finished: {1}ms - {2,number,0.000} rows/sec - ");
        long processTime = System.currentTimeMillis() - this.startTime;
        double rowsPerSecond = (float)this.rowCount * 1000.0f / (float)processTime;
        logger.info((Object)new MemoryUsageMessage(messageFormat.format((Object)new Object[]{Thread.currentThread().getName(), new Long(processTime), new Double(rowsPerSecond)})));
    }
}

