/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.process;

import org.pentaho.reporting.engine.classic.core.layout.model.BlockRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.CanvasRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.InlineRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.LogicalPageBox;
import org.pentaho.reporting.engine.classic.core.layout.model.ParagraphRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderNode;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderableReplacedContentBox;
import org.pentaho.reporting.engine.classic.core.layout.model.table.TableCellRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.table.TableColumnGroupNode;
import org.pentaho.reporting.engine.classic.core.layout.model.table.TableColumnNode;
import org.pentaho.reporting.engine.classic.core.layout.model.table.TableRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.table.TableRowRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.table.TableSectionRenderBox;

public abstract class IterateStructuralProcessStep {
    protected IterateStructuralProcessStep() {
    }

    protected final void startProcessing(RenderNode node) {
        int nodeType = node.getNodeType();
        if (nodeType == 524290) {
            RenderBox box = (RenderBox)node;
            if (this.startAutoBox(box)) {
                this.processBoxChilds(box);
            }
            this.finishAutoBox(box);
        } else if (nodeType == 258) {
            this.processRenderableContent((RenderableReplacedContentBox)node);
        } else if (nodeType == 393218) {
            this.processTableColumn((TableColumnNode)node);
        } else if ((nodeType & 2) == 2) {
            if (nodeType == 266242) {
                TableRenderBox box = (TableRenderBox)node;
                if (this.startTableBox(box)) {
                    this.processBoxChilds(box);
                }
                this.finishTableBox(box);
            } else if (nodeType == 327682) {
                TableColumnGroupNode box = (TableColumnGroupNode)node;
                if (this.startTableColumnGroupBox(box)) {
                    this.processBoxChilds(box);
                }
                this.finishTableColumnGroupBox(box);
            } else if (nodeType == 270338) {
                TableSectionRenderBox box = (TableSectionRenderBox)node;
                if (this.startTableSectionBox(box)) {
                    this.processBoxChilds(box);
                }
                this.finishTableSectionBox(box);
            } else if (nodeType == 278530) {
                TableRowRenderBox box = (TableRowRenderBox)node;
                if (this.startTableRowBox(box)) {
                    this.processBoxChilds(box);
                }
                this.finishTableRowBox(box);
            } else if (nodeType == 294914) {
                TableCellRenderBox box = (TableCellRenderBox)node;
                if (this.startTableCellBox(box)) {
                    this.processBoxChilds(box);
                }
                this.finishTableCellBox(box);
            } else if ((nodeType & 0x12) == 18) {
                if (nodeType == 274) {
                    ParagraphRenderBox box = (ParagraphRenderBox)node;
                    if (this.startBlockBox(box)) {
                        this.processParagraphChilds(box);
                    }
                    this.finishBlockBox(box);
                } else if (nodeType == 1042) {
                    LogicalPageBox box = (LogicalPageBox)node;
                    if (this.startBlockBox(box)) {
                        this.startProcessing(box.getWatermarkArea());
                        this.startProcessing(box.getHeaderArea());
                        this.processBoxChilds(box);
                        this.startProcessing(box.getRepeatFooterArea());
                        this.startProcessing(box.getFooterArea());
                    }
                    this.finishBlockBox(box);
                } else {
                    BlockRenderBox box = (BlockRenderBox)node;
                    if (this.startBlockBox(box)) {
                        this.processBoxChilds(box);
                    }
                    this.finishBlockBox(box);
                }
            } else if ((nodeType & 0x22) == 34) {
                CanvasRenderBox box = (CanvasRenderBox)node;
                if (this.startCanvasBox(box)) {
                    this.processBoxChilds(box);
                }
                this.finishCanvasBox(box);
            } else if ((nodeType & 0x42) == 66) {
                InlineRenderBox box = (InlineRenderBox)node;
                if (this.startInlineBox(box)) {
                    this.processBoxChilds(box);
                }
                this.finishInlineBox(box);
            } else if ((nodeType & 0x82) == 130) {
                RenderBox box = (RenderBox)node;
                if (this.startRowBox(box)) {
                    this.processBoxChilds(box);
                }
                this.finishRowBox(box);
            } else {
                RenderBox box = (RenderBox)node;
                if (this.startOtherBox(box)) {
                    this.processBoxChilds(box);
                }
                this.finishOtherBox(box);
            }
        } else {
            this.processOtherNode(node);
        }
    }

    protected void finishTableCellBox(TableCellRenderBox box) {
    }

    protected boolean startTableCellBox(TableCellRenderBox box) {
        return true;
    }

    protected void finishTableRowBox(TableRowRenderBox box) {
    }

    protected boolean startTableRowBox(TableRowRenderBox box) {
        return true;
    }

    protected void processTableColumn(TableColumnNode node) {
    }

    protected boolean startTableSectionBox(TableSectionRenderBox box) {
        return true;
    }

    protected void finishTableSectionBox(TableSectionRenderBox box) {
    }

    protected boolean startTableColumnGroupBox(TableColumnGroupNode box) {
        return true;
    }

    protected void finishTableColumnGroupBox(TableColumnGroupNode box) {
    }

    protected boolean startTableBox(TableRenderBox box) {
        return true;
    }

    protected void finishTableBox(TableRenderBox box) {
    }

    protected void finishCanvasBox(CanvasRenderBox box) {
    }

    protected boolean startCanvasBox(CanvasRenderBox box) {
        return true;
    }

    protected void processParagraphChilds(ParagraphRenderBox box) {
        this.processBoxChilds(box.getPool());
    }

    protected final void processBoxChilds(RenderBox box) {
        for (RenderNode node = box.getFirstChild(); node != null; node = node.getNext()) {
            this.startProcessing(node);
        }
    }

    protected void processOtherNode(RenderNode node) {
    }

    protected boolean startBlockBox(BlockRenderBox box) {
        return true;
    }

    protected void finishBlockBox(BlockRenderBox box) {
    }

    protected boolean startInlineBox(InlineRenderBox box) {
        return true;
    }

    protected void finishInlineBox(InlineRenderBox box) {
    }

    protected boolean startOtherBox(RenderBox box) {
        return true;
    }

    protected void finishOtherBox(RenderBox box) {
    }

    protected void processRenderableContent(RenderableReplacedContentBox box) {
    }

    protected boolean startRowBox(RenderBox box) {
        return true;
    }

    protected void finishRowBox(RenderBox box) {
    }

    protected boolean startAutoBox(RenderBox box) {
        return true;
    }

    protected void finishAutoBox(RenderBox box) {
    }
}

