/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.process;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.ElementAlignment;
import org.pentaho.reporting.engine.classic.core.InvalidReportStateException;
import org.pentaho.reporting.engine.classic.core.layout.ModelPrinter;
import org.pentaho.reporting.engine.classic.core.layout.model.BlockRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.LogicalPageBox;
import org.pentaho.reporting.engine.classic.core.layout.model.PageBreakPositionList;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderNode;
import org.pentaho.reporting.engine.classic.core.layout.model.context.StaticBoxLayoutProperties;
import org.pentaho.reporting.engine.classic.core.layout.process.util.BasePaginationTableState;
import org.pentaho.reporting.engine.classic.core.layout.process.util.PaginationShiftState;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleKeys;

public final class PaginationStepLib {
    private static final Log logger = LogFactory.getLog(PaginationStepLib.class);

    private PaginationStepLib() {
    }

    public static void configureBreakUtility(PageBreakPositionList breakUtility, LogicalPageBox pageBox, long[] allCurrentBreaks, long reservedHeight, long lastBreakLocal) {
        PageBreakPositionList allPreviousBreak = pageBox.getAllVerticalBreaks();
        breakUtility.copyFrom(allPreviousBreak);
        long pageOffset = pageBox.getPageOffset();
        long headerHeight = pageBox.getHeaderArea().getHeight();
        if (allCurrentBreaks.length == 1) {
            breakUtility.addMajorBreak(pageOffset, headerHeight);
            breakUtility.addMajorBreak(lastBreakLocal - reservedHeight + pageOffset, headerHeight);
        } else {
            breakUtility.addMajorBreak(pageOffset, headerHeight);
            int breakCount = allCurrentBreaks.length - 1;
            for (int i = 1; i < breakCount; ++i) {
                long aBreak = allCurrentBreaks[i];
                breakUtility.addMinorBreak(pageOffset + (aBreak - headerHeight));
            }
            breakUtility.addMajorBreak(pageOffset + (lastBreakLocal - reservedHeight), headerHeight);
        }
    }

    public static void assertProgress(LogicalPageBox pageBox) {
        long lastChildY2;
        RenderNode lastChild = pageBox.getLastChild();
        if (lastChild != null && (lastChildY2 = lastChild.getY() + lastChild.getHeight()) < pageBox.getHeight()) {
            throw new IllegalStateException("Assertation failed: Pagination did not proceed: " + lastChildY2 + " < " + pageBox.getHeight());
        }
    }

    public static long restrictPageAreaHeights(LogicalPageBox pageBox, long[] allCurrentBreaks) {
        BlockRenderBox headerArea = pageBox.getHeaderArea();
        long headerHeight = Math.min(headerArea.getHeight(), allCurrentBreaks[0]);
        headerArea.setHeight(headerHeight);
        BlockRenderBox footerArea = pageBox.getFooterArea();
        BlockRenderBox repeatFooterArea = pageBox.getRepeatFooterArea();
        if (allCurrentBreaks.length > 1) {
            long lastBreakLocal = allCurrentBreaks[allCurrentBreaks.length - 1];
            long lastPageHeight = lastBreakLocal - allCurrentBreaks[allCurrentBreaks.length - 2];
            long footerHeight = Math.min(footerArea.getHeight(), lastPageHeight);
            footerArea.setHeight(footerHeight);
            long repeatFooterHeight = Math.min(repeatFooterArea.getHeight(), lastPageHeight);
            repeatFooterArea.setHeight(repeatFooterHeight);
        }
        long footerHeight = footerArea.getHeight();
        long repeatFooterHeight = repeatFooterArea.getHeight();
        return headerHeight + repeatFooterHeight + footerHeight;
    }

    public static void assertBlockPosition(RenderBox box, long shift) {
        long expectedYPos;
        boolean error;
        if (box.getLayoutNodeType() == 270338) {
            return;
        }
        if (box.getPrev() != null) {
            error = true;
            expectedYPos = box.getPrev().getY() + box.getPrev().getHeight();
        } else if (box.getParent() != null) {
            error = false;
            expectedYPos = box.getParent().getY();
            Object parentVAlignment = box.getParent().getStyleSheet().getStyleProperty(ElementStyleKeys.VALIGNMENT);
            if (parentVAlignment != null && !ElementAlignment.TOP.equals(parentVAlignment)) {
                return;
            }
        } else {
            error = true;
            expectedYPos = 0L;
        }
        long realY = box.getY() + shift;
        if (realY != expectedYPos) {
            long additionalShift = expectedYPos - realY;
            long realShift = shift + additionalShift;
            if (error) {
                ModelPrinter.INSTANCE.print(box);
                ModelPrinter.INSTANCE.print(ModelPrinter.getRoot(box));
                throw new InvalidReportStateException(String.format("Assert: Shift is not as expected: realY=%d != expectation=%d; Shift=%d; AdditionalShift=%d; RealShift=%d", realY, expectedYPos, shift, additionalShift, realShift));
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)String.format("Assert: Shift is not as expected: realY=%d != expectation=%d; Shift=%d; AdditionalShift=%d; RealShift=%d (False positive if block box has valign != TOP", realY, expectedYPos, shift, additionalShift, realShift));
            }
        }
    }

    public static long computeNonBreakableBoxHeight(RenderBox box, PaginationShiftState shiftState, BasePaginationTableState tableState) {
        long widowSize = PaginationStepLib.getWidowConstraint(box, shiftState, tableState);
        StaticBoxLayoutProperties sblp = box.getStaticBoxLayoutProperties();
        if (sblp.isAvoidPagebreakInside() && box.getRestrictFinishedClearOut() != RenderBox.RestrictFinishClearOut.RESTRICTED) {
            return Math.max(widowSize, box.getHeight());
        }
        int nodeType = box.getLayoutNodeType();
        if ((nodeType & 0x12) != 18) {
            return widowSize;
        }
        if (!PaginationStepLib.isOrphanConstraintNeeded(box, shiftState, tableState)) {
            return widowSize;
        }
        long orphanHeight = box.getOrphanConstraintSize();
        if (widowSize + orphanHeight > box.getHeight()) {
            return Math.max(widowSize, box.getHeight());
        }
        return Math.max(orphanHeight, widowSize);
    }

    private static boolean isOrphanConstraintNeeded(RenderBox box, PaginationShiftState shiftState, BasePaginationTableState tableState) {
        long boxY = box.getY() + shiftState.getShiftForNextChild();
        long pageOffset = tableState.getPageOffset(boxY);
        if (pageOffset == boxY) {
            return false;
        }
        if (box.getRestrictFinishedClearOut() != RenderBox.RestrictFinishClearOut.RESTRICTED) {
            return false;
        }
        return !PaginationStepLib.isBoxInsideParentOrphanZoneOnThisPage(box, pageOffset, boxY);
    }

    private static boolean isBoxInsideParentOrphanZoneOnThisPage(RenderBox box, long pageOffset, long boxYShifted) {
        RenderBox parent = box.getParent();
        while (parent != null && parent.getRestrictFinishedClearOut() != RenderBox.RestrictFinishClearOut.UNRESTRICTED && parent.getY() >= pageOffset) {
            if (parent.getOrphanConstraintSize() == 0L) {
                parent = parent.getParent();
                continue;
            }
            long constraintBoundary = parent.getY() + parent.getOrphanConstraintSize();
            if (constraintBoundary > boxYShifted) {
                return true;
            }
            parent = parent.getParent();
        }
        return false;
    }

    public static long getWidowConstraint(RenderBox box, PaginationShiftState shiftState, BasePaginationTableState tableState) {
        if (!box.isWidowBox()) {
            return 0L;
        }
        long boxY = box.getY() + shiftState.getShiftForNextChild();
        long retval = 0L;
        RenderBox parent = box.getParent();
        long pageOffset = tableState.getPageOffset();
        if (pageOffset == boxY) {
            return 0L;
        }
        while (parent != null && parent.getRestrictFinishedClearOut() != RenderBox.RestrictFinishClearOut.UNRESTRICTED) {
            if (parent.getWidowConstraintSize() == 0L) {
                parent = parent.getParent();
                continue;
            }
            long y2 = parent.getY2();
            long constraintBoundary = parent.getY() < pageOffset ? y2 - Math.max(0L, parent.getWidowConstraintSize()) : y2 - Math.max(0L, parent.getWidowConstraintSizeWithKeepTogether());
            if (constraintBoundary == boxY) {
                retval = Math.max(retval, y2 - boxY);
            }
            parent = parent.getParent();
        }
        return retval;
    }
}

