/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.process.text;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.ElementAlignment;
import org.pentaho.reporting.engine.classic.core.InvalidReportStateException;
import org.pentaho.reporting.engine.classic.core.layout.model.FinishedRenderNode;
import org.pentaho.reporting.engine.classic.core.layout.model.PageGrid;
import org.pentaho.reporting.engine.classic.core.layout.model.ParagraphPoolBox;
import org.pentaho.reporting.engine.classic.core.layout.model.ParagraphRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderNode;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessorMetaData;
import org.pentaho.reporting.engine.classic.core.layout.process.AbstractMinorAxisLayoutStep;
import org.pentaho.reporting.engine.classic.core.layout.process.IterateSimpleStructureProcessStep;
import org.pentaho.reporting.engine.classic.core.layout.process.alignment.CenterAlignmentProcessor;
import org.pentaho.reporting.engine.classic.core.layout.process.alignment.JustifyAlignmentProcessor;
import org.pentaho.reporting.engine.classic.core.layout.process.alignment.LeftAlignmentProcessor;
import org.pentaho.reporting.engine.classic.core.layout.process.alignment.RightAlignmentProcessor;
import org.pentaho.reporting.engine.classic.core.layout.process.alignment.TextAlignmentProcessor;
import org.pentaho.reporting.engine.classic.core.layout.process.layoutrules.EndSequenceElement;
import org.pentaho.reporting.engine.classic.core.layout.process.layoutrules.InlineNodeSequenceElement;
import org.pentaho.reporting.engine.classic.core.layout.process.layoutrules.ReplacedContentSequenceElement;
import org.pentaho.reporting.engine.classic.core.layout.process.layoutrules.SequenceList;
import org.pentaho.reporting.engine.classic.core.layout.process.layoutrules.SpacerSequenceElement;
import org.pentaho.reporting.engine.classic.core.layout.process.layoutrules.StartSequenceElement;
import org.pentaho.reporting.engine.classic.core.layout.process.layoutrules.TextSequenceElement;
import org.pentaho.reporting.engine.classic.core.layout.process.text.TextMinorAxisLayoutStep;
import org.pentaho.reporting.engine.classic.core.layout.process.util.MinorAxisNodeContext;
import org.pentaho.reporting.engine.classic.core.layout.process.util.MinorAxisParagraphBreakState;
import org.pentaho.reporting.engine.classic.core.style.StyleSheet;
import org.pentaho.reporting.engine.classic.core.style.TextStyleKeys;
import org.pentaho.reporting.engine.classic.core.style.WhitespaceCollapse;
import org.pentaho.reporting.libraries.base.util.ArgumentNullException;

public class SimpleTextMinorAxisLayoutStep
extends IterateSimpleStructureProcessStep
implements TextMinorAxisLayoutStep {
    private static final Log logger = LogFactory.getLog(SimpleTextMinorAxisLayoutStep.class);
    private MinorAxisParagraphBreakState lineBreakState;
    private MinorAxisNodeContext nodeContext;
    private PageGrid pageGrid;
    private OutputProcessorMetaData metaData;
    private TextAlignmentProcessor centerProcessor;
    private TextAlignmentProcessor rightProcessor;
    private TextAlignmentProcessor leftProcessor;
    private TextAlignmentProcessor justifyProcessor;

    public SimpleTextMinorAxisLayoutStep(OutputProcessorMetaData metaData) {
        ArgumentNullException.validate((String)"metaData", (Object)metaData);
        this.metaData = metaData;
        this.lineBreakState = new MinorAxisParagraphBreakState();
    }

    public MinorAxisNodeContext getNodeContext() {
        return this.nodeContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(ParagraphRenderBox box, MinorAxisNodeContext nodeContext, PageGrid pageGrid) {
        this.nodeContext = nodeContext;
        this.pageGrid = pageGrid;
        try {
            this.lineBreakState.init(box);
            this.processParagraphChildsNormal(box);
            this.lineBreakState.deinit();
        }
        finally {
            this.pageGrid = null;
        }
    }

    private void processParagraphChildsNormal(ParagraphRenderBox box) {
        MinorAxisParagraphBreakState breakState = this.getLineBreakState();
        if (box.isComplexParagraph()) {
            RenderBox lineboxContainer = box.getLineboxContainer();
            for (RenderNode node = lineboxContainer.getFirstChild(); node != null; node = node.getNext()) {
                if (node.getNodeType() != 322) {
                    throw new IllegalStateException("Expected ParagraphPoolBox elements.");
                }
                ParagraphPoolBox inlineRenderBox = (ParagraphPoolBox)node;
                if (!this.startLine(inlineRenderBox)) continue;
                this.processBoxChilds(inlineRenderBox);
                this.finishLine(inlineRenderBox, breakState);
            }
        } else {
            ParagraphPoolBox node = box.getPool();
            if (node.getFirstChild() == null) {
                return;
            }
            if (this.startLine(node)) {
                this.processBoxChilds(node);
                this.finishLine(node, breakState);
            }
        }
    }

    private boolean startLine(RenderBox inlineRenderBox) {
        MinorAxisParagraphBreakState breakState = this.getLineBreakState();
        if (!breakState.isInsideParagraph()) {
            return false;
        }
        if (breakState.isSuspended()) {
            return false;
        }
        breakState.clear();
        breakState.add(StartSequenceElement.INSTANCE, inlineRenderBox);
        return true;
    }

    private void finishLine(RenderBox inlineRenderBox, MinorAxisParagraphBreakState breakState) {
        if (!breakState.isInsideParagraph() || breakState.isSuspended()) {
            throw new IllegalStateException("No active breakstate, finish-line cannot continue.");
        }
        MinorAxisNodeContext nodeContext = this.getNodeContext();
        PageGrid pageGrid = this.getPageGrid();
        OutputProcessorMetaData metaData = this.getMetaData();
        breakState.add(EndSequenceElement.INSTANCE, inlineRenderBox);
        ParagraphRenderBox paragraph = breakState.getParagraph();
        ElementAlignment textAlignment = paragraph.getTextAlignment();
        long textIndent = paragraph.getTextIndent();
        long firstLineIndent = paragraph.getFirstLineIndent();
        TextAlignmentProcessor processor = this.create(textAlignment);
        SequenceList sequence = breakState.getSequence();
        boolean overflowX = paragraph.getStaticBoxLayoutProperties().isOverflowX();
        long lineEnd = overflowX ? nodeContext.getX1() + AbstractMinorAxisLayoutStep.OVERFLOW_DUMMY_WIDTH : nodeContext.getX2();
        long lineStart = Math.min(lineEnd, nodeContext.getX1() + firstLineIndent);
        if (lineEnd - lineStart <= 0L) {
            long minimumChunkWidth = paragraph.getPool().getMinimumChunkWidth();
            processor.initialize(metaData, sequence, lineStart, lineStart + minimumChunkWidth, pageGrid, overflowX);
            nodeContext.updateX2(lineStart + minimumChunkWidth);
            logger.warn((Object)("Auto-Corrected zero-width first-line on paragraph - " + paragraph.getName()));
        } else {
            processor.initialize(metaData, sequence, lineStart, lineEnd, pageGrid, overflowX);
            if (!overflowX) {
                nodeContext.updateX2(lineEnd);
            }
        }
        while (processor.hasNext()) {
            RenderBox linebox = processor.next();
            if (linebox.getLayoutNodeType() != 322) {
                throw new IllegalStateException("Line must not be null");
            }
            paragraph.addGeneratedChild(linebox);
            if (!processor.hasNext()) continue;
            lineStart = Math.min(lineEnd, nodeContext.getX1() + textIndent);
            if (lineEnd - lineStart <= 0L) {
                long minimumChunkWidth = paragraph.getPool().getMinimumChunkWidth();
                processor.updateLineSize(lineStart, lineStart + minimumChunkWidth);
                nodeContext.updateX2(lineStart + minimumChunkWidth);
                logger.warn((Object)("Auto-Corrected zero-width text-line on paragraph continuation - " + paragraph.getName()));
                continue;
            }
            processor.updateLineSize(lineStart, lineEnd);
            if (overflowX) continue;
            nodeContext.updateX2(lineEnd);
        }
        processor.deinitialize();
    }

    @Override
    protected boolean startBox(RenderBox box) {
        if (!this.lineBreakState.isInsideParagraph()) {
            throw new InvalidReportStateException("A inline-level box outside of a paragraph box is not allowed.");
        }
        int nodeType = box.getLayoutNodeType();
        if (nodeType == 258) {
            this.lineBreakState.add(ReplacedContentSequenceElement.INSTANCE, box);
            return false;
        }
        this.lineBreakState.add(StartSequenceElement.INSTANCE, box);
        return true;
    }

    @Override
    protected void processOtherNode(RenderNode node) {
        if (!this.lineBreakState.isInsideParagraph()) {
            throw new InvalidReportStateException("A inline-level box outside of a paragraph box is not allowed.");
        }
        int nodeType = node.getNodeType();
        if (nodeType == 129) {
            FinishedRenderNode finNode = (FinishedRenderNode)node;
            node.setCachedWidth(finNode.getLayoutedWidth());
            return;
        }
        if (nodeType == 17) {
            this.lineBreakState.add(TextSequenceElement.INSTANCE, node);
        } else if (nodeType == 65) {
            StyleSheet styleSheet = node.getStyleSheet();
            if (WhitespaceCollapse.PRESERVE.equals(styleSheet.getStyleProperty(TextStyleKeys.WHITE_SPACE_COLLAPSE)) && !styleSheet.getBooleanStyleProperty(TextStyleKeys.TRIM_TEXT_CONTENT)) {
                this.lineBreakState.add(SpacerSequenceElement.INSTANCE, node);
            } else if (this.lineBreakState.isContainsContent()) {
                this.lineBreakState.add(SpacerSequenceElement.INSTANCE, node);
            }
        } else {
            this.lineBreakState.add(InlineNodeSequenceElement.INSTANCE, node);
        }
    }

    @Override
    protected void finishBox(RenderBox box) {
        if (!this.lineBreakState.isInsideParagraph()) {
            throw new InvalidReportStateException("A inline-level box outside of a paragraph box is not allowed.");
        }
        int nodeType = box.getLayoutNodeType();
        if (nodeType == 258) {
            return;
        }
        this.lineBreakState.add(EndSequenceElement.INSTANCE, box);
    }

    protected TextAlignmentProcessor create(ElementAlignment alignment) {
        if (ElementAlignment.CENTER.equals(alignment)) {
            if (this.centerProcessor == null) {
                this.centerProcessor = new CenterAlignmentProcessor();
            }
            return this.centerProcessor;
        }
        if (ElementAlignment.RIGHT.equals(alignment)) {
            if (this.rightProcessor == null) {
                this.rightProcessor = new RightAlignmentProcessor();
            }
            return this.rightProcessor;
        }
        if (ElementAlignment.JUSTIFY.equals(alignment)) {
            if (this.justifyProcessor == null) {
                this.justifyProcessor = new JustifyAlignmentProcessor();
            }
            return this.justifyProcessor;
        }
        if (this.leftProcessor == null) {
            this.leftProcessor = new LeftAlignmentProcessor();
        }
        return this.leftProcessor;
    }

    public PageGrid getPageGrid() {
        return this.pageGrid;
    }

    public OutputProcessorMetaData getMetaData() {
        return this.metaData;
    }

    protected MinorAxisParagraphBreakState getLineBreakState() {
        return this.lineBreakState;
    }
}

