/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.process.util;

import org.pentaho.reporting.engine.classic.core.layout.model.LogicalPageBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.context.StaticBoxLayoutProperties;
import org.pentaho.reporting.engine.classic.core.layout.process.util.MinorAxisLogicalPageContext;
import org.pentaho.reporting.engine.classic.core.layout.process.util.MinorAxisNodeContext;
import org.pentaho.reporting.engine.classic.core.layout.process.util.StackedObjectPool;

public class MinorAxisNodeContextPool
extends StackedObjectPool<MinorAxisNodeContext> {
    @Override
    public MinorAxisNodeContext create() {
        return new MinorAxisNodeContext(this);
    }

    private boolean isEstablishBlockContext(int nodeType, boolean definedWidth) {
        if ((nodeType & 0x12) == 18) {
            return definedWidth;
        }
        if ((nodeType & 0x22) == 34) {
            return definedWidth;
        }
        if ((nodeType & 0x82) == 130) {
            return definedWidth;
        }
        if ((nodeType & 0x41002) == 266242) {
            return true;
        }
        if ((nodeType & 0x42002) == 270338) {
            return true;
        }
        return (nodeType & 0x48002) == 294914;
    }

    public MinorAxisNodeContext createContext(RenderBox box, MinorAxisNodeContext context, boolean blockLevelNode) {
        boolean horizontal;
        MinorAxisNodeContext nodeContext;
        int nodeType = box.getNodeType();
        if (nodeType == 1042) {
            nodeContext = new MinorAxisLogicalPageContext((LogicalPageBox)box);
            horizontal = false;
        } else {
            nodeContext = (MinorAxisNodeContext)this.get();
            nodeContext.reuseParent(context);
            int layoutNodeType = box.getLayoutNodeType();
            horizontal = (layoutNodeType & 0x82) == 130 || layoutNodeType == 278530;
        }
        StaticBoxLayoutProperties sblp = box.getStaticBoxLayoutProperties();
        nodeContext.reuse(horizontal, blockLevelNode, box.isBoxOverflowX(), this.isEstablishBlockContext(box.getNodeType(), sblp.isDefinedWidth()));
        return nodeContext;
    }
}

