/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.metadata.propertyeditors;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditor;
import org.pentaho.reporting.engine.classic.core.ElementAlignment;

public class HorizontalAlignmentPropertyEditor
implements PropertyEditor {
    private ElementAlignment value;
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    @Override
    public void setValue(Object value) {
        ElementAlignment oldValue = this.value;
        this.value = ElementAlignment.LEFT.equals(value) ? ElementAlignment.LEFT : (ElementAlignment.CENTER.equals(value) ? ElementAlignment.CENTER : (ElementAlignment.RIGHT.equals(value) ? ElementAlignment.RIGHT : (ElementAlignment.JUSTIFY.equals(value) ? ElementAlignment.JUSTIFY : null)));
        this.propertyChangeSupport.firePropertyChange(null, oldValue, this.value);
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public boolean isPaintable() {
        return false;
    }

    @Override
    public void paintValue(Graphics gfx, Rectangle box) {
    }

    @Override
    public String getJavaInitializationString() {
        if (ElementAlignment.LEFT.equals(this.value)) {
            return ElementAlignment.class.getName() + ".LEFT";
        }
        if (ElementAlignment.CENTER.equals(this.value)) {
            return ElementAlignment.class.getName() + ".CENTER";
        }
        if (ElementAlignment.RIGHT.equals(this.value)) {
            return ElementAlignment.class.getName() + ".RIGHT";
        }
        if (ElementAlignment.JUSTIFY.equals(this.value)) {
            return ElementAlignment.class.getName() + ".JUSTIFY";
        }
        return "null";
    }

    @Override
    public String getAsText() {
        if (ElementAlignment.LEFT.equals(this.value)) {
            return "LEFT";
        }
        if (ElementAlignment.CENTER.equals(this.value)) {
            return "CENTER";
        }
        if (ElementAlignment.RIGHT.equals(this.value)) {
            return "RIGHT";
        }
        if (ElementAlignment.JUSTIFY.equals(this.value)) {
            return "JUSTIFY";
        }
        return null;
    }

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        if (ElementAlignment.LEFT.toString().equals(text)) {
            this.setValue(ElementAlignment.LEFT);
        } else if (ElementAlignment.CENTER.toString().equals(text)) {
            this.setValue(ElementAlignment.CENTER);
        } else if (ElementAlignment.RIGHT.toString().equals(text)) {
            this.setValue(ElementAlignment.RIGHT);
        } else if (ElementAlignment.JUSTIFY.toString().equals(text)) {
            this.setValue(ElementAlignment.JUSTIFY);
        } else {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public String[] getTags() {
        return new String[]{"LEFT", "CENTER", "RIGHT", "JUSTIFY"};
    }

    @Override
    public Component getCustomEditor() {
        return null;
    }

    @Override
    public boolean supportsCustomEditor() {
        return false;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }
}

