/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.gui.base.actions;

import java.util.Locale;
import javax.swing.Icon;
import javax.swing.KeyStroke;
import org.pentaho.reporting.engine.classic.core.modules.gui.base.PreviewPane;
import org.pentaho.reporting.engine.classic.core.modules.gui.base.SwingPreviewModule;
import org.pentaho.reporting.engine.classic.core.modules.gui.base.actions.ControlActionPlugin;
import org.pentaho.reporting.engine.classic.core.modules.gui.base.actions.PaginatedUpdateListener;
import org.pentaho.reporting.engine.classic.core.modules.gui.base.internal.PreviewPaneUtilities;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.AbstractActionPlugin;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.SwingGuiContext;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.base.util.ResourceBundleSupport;

public class ZoomOutActionPlugin
extends AbstractActionPlugin
implements ControlActionPlugin {
    private ResourceBundleSupport resources;
    private PaginatedUpdateListener updateListener = new PaginatedUpdateListener(this);

    @Override
    public void deinitialize(SwingGuiContext swingGuiContext) {
        super.deinitialize(swingGuiContext);
        swingGuiContext.getEventSource().removePropertyChangeListener(this.updateListener);
    }

    @Override
    public boolean initialize(SwingGuiContext context) {
        super.initialize(context);
        this.resources = new ResourceBundleSupport(context.getLocale(), "org.pentaho.reporting.engine.classic.core.modules.gui.base.messages.messages", ObjectUtilities.getClassLoader(SwingPreviewModule.class));
        context.getEventSource().addPropertyChangeListener(this.updateListener);
        this.setEnabled(context.getEventSource().isPaginated());
        return true;
    }

    @Override
    protected String getConfigurationPrefix() {
        return "org.pentaho.reporting.engine.classic.core.modules.gui.base.zoom-out.";
    }

    @Override
    public String getDisplayName() {
        return this.resources.getString("action.zoomOut.name");
    }

    @Override
    public String getShortDescription() {
        return this.resources.getString("action.zoomOut.description");
    }

    @Override
    public Icon getSmallIcon() {
        Locale locale = this.getContext().getLocale();
        return this.getIconTheme().getSmallIcon(locale, "action.zoomOut.small-icon");
    }

    @Override
    public Icon getLargeIcon() {
        Locale locale = this.getContext().getLocale();
        return this.getIconTheme().getLargeIcon(locale, "action.zoomOut.icon");
    }

    @Override
    public KeyStroke getAcceleratorKey() {
        String charAccelerator = this.resources.getString("action.zoomOut.char-accelerator");
        if (charAccelerator.length() > 0) {
            return KeyStroke.getKeyStroke(charAccelerator.charAt(0));
        }
        return this.resources.getOptionalKeyStroke("action.zoomOut.accelerator");
    }

    @Override
    public Integer getMnemonicKey() {
        return this.resources.getOptionalMnemonic("action.zoomOut.mnemonic");
    }

    @Override
    public boolean configure(PreviewPane reportPane) {
        double nextZoomOut = PreviewPaneUtilities.getNextZoomOut(reportPane.getZoom(), reportPane.getZoomFactors());
        if (nextZoomOut == 0.0) {
            return false;
        }
        reportPane.setZoom(nextZoomOut);
        return true;
    }
}

